@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.GetPipelineJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Azure Video Analyzer account name.
 * @property pipelineJobName The pipeline job name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPipelineJobPlainArgs(
    public val accountName: String,
    public val pipelineJobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.GetPipelineJobPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.GetPipelineJobPlainArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.GetPipelineJobPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .pipelineJobName(pipelineJobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelineJobPlainArgs].
 */
@PulumiTagMarker
public class GetPipelineJobPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var pipelineJobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("arofqtlfxxiysnhw")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The pipeline job name.
     */
    @JvmName("wiwexjrljvwsyykv")
    public suspend fun pipelineJobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineJobName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jidrnxohgjqjqrjb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPipelineJobPlainArgs = GetPipelineJobPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        pipelineJobName = pipelineJobName ?: throw PulumiNullFieldException("pipelineJobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
