@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.NodeInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an input signal to be used on a pipeline node.
 * @property nodeName The name of the upstream node in the pipeline which output is used as input of the current node.
 */
public data class NodeInputArgs(
    public val nodeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.NodeInputArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.NodeInputArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.NodeInputArgs.builder()
            .nodeName(nodeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodeInputArgs].
 */
@PulumiTagMarker
public class NodeInputArgsBuilder internal constructor() {
    private var nodeName: Output<String>? = null

    /**
     * @param value The name of the upstream node in the pipeline which output is used as input of the current node.
     */
    @JvmName("hceyjipqoyhjdcwq")
    public suspend fun nodeName(`value`: Output<String>) {
        this.nodeName = value
    }

    /**
     * @param value The name of the upstream node in the pipeline which output is used as input of the current node.
     */
    @JvmName("uovjwnhlfnespkfl")
    public suspend fun nodeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeName = mapped
    }

    internal fun build(): NodeInputArgs = NodeInputArgs(
        nodeName = nodeName ?: throw PulumiNullFieldException("nodeName"),
    )
}
