@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.ParameterDeclarationArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.enums.ParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Single topology parameter declaration. Declared parameters can and must be referenced throughout the topology and can optionally have default values to be used when they are not defined in the pipelines.
 * @property default The default value for the parameter to be used if the pipeline does not specify a value.
 * @property description Description of the parameter.
 * @property name Name of the parameter.
 * @property type Type of the parameter.
 */
public data class ParameterDeclarationArgs(
    public val default: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val type: Output<Either<String, ParameterType>>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.ParameterDeclarationArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.ParameterDeclarationArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.ParameterDeclarationArgs.builder()
            .default_(default?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ParameterDeclarationArgs].
 */
@PulumiTagMarker
public class ParameterDeclarationArgsBuilder internal constructor() {
    private var default: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<Either<String, ParameterType>>? = null

    /**
     * @param value The default value for the parameter to be used if the pipeline does not specify a value.
     */
    @JvmName("qihiaxdmrbmchkjx")
    public suspend fun default(`value`: Output<String>) {
        this.default = value
    }

    /**
     * @param value Description of the parameter.
     */
    @JvmName("wtlfrlpdevnwyshf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the parameter.
     */
    @JvmName("jasaphwatrdoottb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of the parameter.
     */
    @JvmName("ckmfssybyutxtduo")
    public suspend fun type(`value`: Output<Either<String, ParameterType>>) {
        this.type = value
    }

    /**
     * @param value The default value for the parameter to be used if the pipeline does not specify a value.
     */
    @JvmName("aejcvubcrhntnppq")
    public suspend fun default(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value Description of the parameter.
     */
    @JvmName("ewcgwoxskuejtbvi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the parameter.
     */
    @JvmName("qyhtfyfpfruqobny")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of the parameter.
     */
    @JvmName("hjyratvuwjbdiiax")
    public suspend fun type(`value`: Either<String, ParameterType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the parameter.
     */
    @JvmName("nknnjrcoexvkkqol")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the parameter.
     */
    @JvmName("cclvsubelhnhielr")
    public fun type(`value`: ParameterType) {
        val toBeMapped = Either.ofRight<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ParameterDeclarationArgs = ParameterDeclarationArgs(
        default = default,
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
