@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.PemCertificateListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A list of PEM formatted certificates.
 * @property certificates PEM formatted public certificates. One certificate per entry.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.PemCertificateList'.
 */
public data class PemCertificateListArgs(
    public val certificates: Output<List<String>>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.PemCertificateListArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.PemCertificateListArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.PemCertificateListArgs.builder()
            .certificates(certificates.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PemCertificateListArgs].
 */
@PulumiTagMarker
public class PemCertificateListArgsBuilder internal constructor() {
    private var certificates: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value PEM formatted public certificates. One certificate per entry.
     */
    @JvmName("gvujgbjamyqotcvm")
    public suspend fun certificates(`value`: Output<List<String>>) {
        this.certificates = value
    }

    @JvmName("kueooepglhxjexdq")
    public suspend fun certificates(vararg values: Output<String>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values PEM formatted public certificates. One certificate per entry.
     */
    @JvmName("ijcwumhpusldpaxu")
    public suspend fun certificates(values: List<Output<String>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.PemCertificateList'.
     */
    @JvmName("mumhurxybjctfqvl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value PEM formatted public certificates. One certificate per entry.
     */
    @JvmName("hgkxdirooohrsyee")
    public suspend fun certificates(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param values PEM formatted public certificates. One certificate per entry.
     */
    @JvmName("vdijktxlmtlorudy")
    public suspend fun certificates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.PemCertificateList'.
     */
    @JvmName("xatybfpxanqaihfa")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PemCertificateListArgs = PemCertificateListArgs(
        certificates = certificates ?: throw PulumiNullFieldException("certificates"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
