@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.SecureIotDeviceRemoteTunnelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A remote tunnel securely established using IoT Hub device information.
 * @property deviceId The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
 * @property iotHubName Name of the IoT Hub.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel'.
 */
public data class SecureIotDeviceRemoteTunnelArgs(
    public val deviceId: Output<String>,
    public val iotHubName: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.SecureIotDeviceRemoteTunnelArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.SecureIotDeviceRemoteTunnelArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.SecureIotDeviceRemoteTunnelArgs.builder()
            .deviceId(deviceId.applyValue({ args0 -> args0 }))
            .iotHubName(iotHubName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecureIotDeviceRemoteTunnelArgs].
 */
@PulumiTagMarker
public class SecureIotDeviceRemoteTunnelArgsBuilder internal constructor() {
    private var deviceId: Output<String>? = null

    private var iotHubName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
     */
    @JvmName("ourlwblilihffgit")
    public suspend fun deviceId(`value`: Output<String>) {
        this.deviceId = value
    }

    /**
     * @param value Name of the IoT Hub.
     */
    @JvmName("xjhpynahdifmjtxw")
    public suspend fun iotHubName(`value`: Output<String>) {
        this.iotHubName = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel'.
     */
    @JvmName("sgbgpchhtpthydlj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The IoT device id to use when establishing the remote tunnel. This string is case-sensitive.
     */
    @JvmName("rbsrrjyvshvybndt")
    public suspend fun deviceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceId = mapped
    }

    /**
     * @param value Name of the IoT Hub.
     */
    @JvmName("hcdyelftrgvpojgf")
    public suspend fun iotHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iotHubName = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel'.
     */
    @JvmName("gqsxdgfkyggbelnf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SecureIotDeviceRemoteTunnelArgs = SecureIotDeviceRemoteTunnelArgs(
        deviceId = deviceId ?: throw PulumiNullFieldException("deviceId"),
        iotHubName = iotHubName ?: throw PulumiNullFieldException("iotHubName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
