@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoArchivalArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Video archival properties.
 * @property retentionPeriod Video retention period indicates the maximum age of the video archive segments which are intended to be kept in storage. It must be provided in the ISO8601 duration format in the granularity of days, up to a maximum of 10 years. For example, if this is set to P30D (30 days), content older than 30 days will be periodically deleted. This value can be updated at any time and the new desired retention period will be effective within 24 hours.
 */
public data class VideoArchivalArgs(
    public val retentionPeriod: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoArchivalArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoArchivalArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoArchivalArgs.builder()
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoArchivalArgs].
 */
@PulumiTagMarker
public class VideoArchivalArgsBuilder internal constructor() {
    private var retentionPeriod: Output<String>? = null

    /**
     * @param value Video retention period indicates the maximum age of the video archive segments which are intended to be kept in storage. It must be provided in the ISO8601 duration format in the granularity of days, up to a maximum of 10 years. For example, if this is set to P30D (30 days), content older than 30 days will be periodically deleted. This value can be updated at any time and the new desired retention period will be effective within 24 hours.
     */
    @JvmName("cmjriwphhtefkqmk")
    public suspend fun retentionPeriod(`value`: Output<String>) {
        this.retentionPeriod = value
    }

    /**
     * @param value Video retention period indicates the maximum age of the video archive segments which are intended to be kept in storage. It must be provided in the ISO8601 duration format in the granularity of days, up to a maximum of 10 years. For example, if this is set to P30D (30 days), content older than 30 days will be periodically deleted. This value can be updated at any time and the new desired retention period will be effective within 24 hours.
     */
    @JvmName("esdovbktrmnaealr")
    public suspend fun retentionPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    internal fun build(): VideoArchivalArgs = VideoArchivalArgs(
        retentionPeriod = retentionPeriod,
    )
}
