@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.VideoSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Video source allows for content from a Video Analyzer video resource to be ingested into a pipeline. Currently supported only with batch pipelines.
 * @property name Node name. Must be unique within the topology.
 * @property timeSequences Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.VideoSource'.
 * @property videoName Name of the Video Analyzer video resource to be used as the source.
 */
public data class VideoSourceArgs(
    public val name: Output<String>,
    public val timeSequences: Output<VideoSequenceAbsoluteTimeMarkersArgs>,
    public val type: Output<String>,
    public val videoName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.VideoSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.VideoSourceArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.VideoSourceArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .timeSequences(timeSequences.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 }))
            .videoName(videoName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoSourceArgs].
 */
@PulumiTagMarker
public class VideoSourceArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var timeSequences: Output<VideoSequenceAbsoluteTimeMarkersArgs>? = null

    private var type: Output<String>? = null

    private var videoName: Output<String>? = null

    /**
     * @param value Node name. Must be unique within the topology.
     */
    @JvmName("dbdgxbavaoafcxto")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
     */
    @JvmName("ldwjxiqjprulpsmc")
    public suspend fun timeSequences(`value`: Output<VideoSequenceAbsoluteTimeMarkersArgs>) {
        this.timeSequences = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.VideoSource'.
     */
    @JvmName("aqkrbjuvmfpjotfe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name of the Video Analyzer video resource to be used as the source.
     */
    @JvmName("dpqrwurptgvxblcx")
    public suspend fun videoName(`value`: Output<String>) {
        this.videoName = value
    }

    /**
     * @param value Node name. Must be unique within the topology.
     */
    @JvmName("dsdtyujukrefroux")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
     */
    @JvmName("hspjkiprdjpkmgth")
    public suspend fun timeSequences(`value`: VideoSequenceAbsoluteTimeMarkersArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeSequences = mapped
    }

    /**
     * @param argument Describes a sequence of datetime ranges. The video source only picks up recorded media within these ranges.
     */
    @JvmName("nnxdhtfsnkhawptb")
    public suspend
    fun timeSequences(argument: suspend VideoSequenceAbsoluteTimeMarkersArgsBuilder.() -> Unit) {
        val toBeMapped = VideoSequenceAbsoluteTimeMarkersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeSequences = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.VideoSource'.
     */
    @JvmName("svprsveliwordfpj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Name of the Video Analyzer video resource to be used as the source.
     */
    @JvmName("ynfpkxkngfblpumr")
    public suspend fun videoName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.videoName = mapped
    }

    internal fun build(): VideoSourceArgs = VideoSourceArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        timeSequences = timeSequences ?: throw PulumiNullFieldException("timeSequences"),
        type = type ?: throw PulumiNullFieldException("type"),
        videoName = videoName ?: throw PulumiNullFieldException("videoName"),
    )
}
