@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the parameter value of an specific pipeline topology parameter. See pipeline topology parameters for more information.
 * @property name Name of the parameter declared in the pipeline topology.
 * @property value Parameter value to be applied on this specific pipeline.
 */
public data class ParameterDefinitionResponse(
    public val name: String,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.ParameterDefinitionResponse):
            ParameterDefinitionResponse = ParameterDefinitionResponse(
            name = javaType.name(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
