@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties for expected token claims.
 * @property name Name of the claim which must be present on the token.
 * @property value Expected value of the claim to be present on the token.
 */
public data class TokenClaimResponse(
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.TokenClaimResponse):
            TokenClaimResponse = TokenClaimResponse(
            name = javaType.name(),
            `value` = javaType.`value`(),
        )
    }
}
