@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Set of URLs to the video content.
 * @property archiveBaseUrl Video archive streaming base URL. The archived content can be automatically played by the Azure Video Analyzer player widget. Alternatively, this URL can be used in conjunction with the video content authorization token on any compatible DASH or HLS players by appending the following to the base URL:
 *     - HLSv4:     /manifest(format=m3u8-aapl).m3u8
 *     - HLS CMAF:  /manifest(format=m3u8-cmaf)
 *     - DASH CMAF: /manifest(format=mpd-time-cmaf)
 *     Moreover, an ongoing video recording can be played in "live mode" with latencies which are approximately double of the chosen video segment length. It is available when the video type is 'archive' and video archiving is enabled.
 * @property downloadUrl Video file download URL. This URL can be used in conjunction with the video content authorization token to download the video MP4 file. The resulting MP4 file can be played on any standard media player. It is available when the video type is 'file' and video file is available for consumption.
 * @property previewImageUrls Video preview image URLs. These URLs can be used in conjunction with the video content authorization token to download the most recent still image from the video archive in different resolutions. They are available when the video type is 'archive' and preview images are enabled.
 * @property rtspTunnelUrl Video low-latency streaming URL. The live content can be automatically played by the Azure Video Analyzer player widget. Alternatively, this URL can be used in conjunction with the video content authorization token to expose a WebSocket tunneled RTSP stream. It is available when the video type is 'archive' and a live, low-latency feed is available from the source.
 */
public data class VideoContentUrlsResponse(
    public val archiveBaseUrl: String? = null,
    public val downloadUrl: String? = null,
    public val previewImageUrls: VideoPreviewImageUrlsResponse? = null,
    public val rtspTunnelUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.outputs.VideoContentUrlsResponse):
            VideoContentUrlsResponse = VideoContentUrlsResponse(
            archiveBaseUrl = javaType.archiveBaseUrl().map({ args0 -> args0 }).orElse(null),
            downloadUrl = javaType.downloadUrl().map({ args0 -> args0 }).orElse(null),
            previewImageUrls = javaType.previewImageUrls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoPreviewImageUrlsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rtspTunnelUrl = javaType.rtspTunnelUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
