@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoindexer.kotlin

import com.pulumi.azurenative.videoindexer.AccountArgs.builder
import com.pulumi.azurenative.videoindexer.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.videoindexer.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.videoindexer.kotlin.inputs.MediaServicesForPutRequestArgs
import com.pulumi.azurenative.videoindexer.kotlin.inputs.MediaServicesForPutRequestArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Video Indexer account.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-10-18-preview.
 * Other available API versions: 2024-01-01.
 * ## Example Usage
 * ### Put example #9
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.VideoIndexer.Account("account", new()
 *     {
 *         AccountName = "contosto-videoanalyzer",
 *         ResourceGroupName = "contosto-videoanalyzer-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoindexer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoindexer.NewAccount(ctx, "account", &videoindexer.AccountArgs{
 * 			AccountName:       pulumi.String("contosto-videoanalyzer"),
 * 			ResourceGroupName: pulumi.String("contosto-videoanalyzer-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoindexer.Account;
 * import com.pulumi.azurenative.videoindexer.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("contosto-videoanalyzer")
 *             .resourceGroupName("contosto-videoanalyzer-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoindexer:Account contosto-videoanalyzer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VideoIndexer/accounts/{accountName}
 * ```
 * @property accountId The account's data-plane ID. This can be set only when connecting an existing classic account
 * @property accountName The name of the Azure Video Indexer account.
 * @property identity Managed service identity (system assigned and/or user assigned identities)
 * @property location The geo-location where the resource lives
 * @property mediaServices The media services details
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AccountArgs(
    public val accountId: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val mediaServices: Output<MediaServicesForPutRequestArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoindexer.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.videoindexer.AccountArgs =
        com.pulumi.azurenative.videoindexer.AccountArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mediaServices(mediaServices?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var accountName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var mediaServices: Output<MediaServicesForPutRequestArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The account's data-plane ID. This can be set only when connecting an existing classic account
     */
    @JvmName("iqsvhrsrtfdcfleb")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The name of the Azure Video Indexer account.
     */
    @JvmName("ddyjnyomqvlqhxdu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("bfioxvxjmpmislam")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pvwfctlifyolifot")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The media services details
     */
    @JvmName("sjsedhuxdyctcqcn")
    public suspend fun mediaServices(`value`: Output<MediaServicesForPutRequestArgs>) {
        this.mediaServices = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ultkenjtchdwjneg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dcoymtaoymoifmmv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The account's data-plane ID. This can be set only when connecting an existing classic account
     */
    @JvmName("apanqnhqhlpgigbi")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The name of the Azure Video Indexer account.
     */
    @JvmName("ajabjtbqnxclbjiy")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("hoebautiyyhkxcyg")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("dklxjsnedooabvlg")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jctcqyhlgtperkpe")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The media services details
     */
    @JvmName("yvvfpfsvrgnmlaul")
    public suspend fun mediaServices(`value`: MediaServicesForPutRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaServices = mapped
    }

    /**
     * @param argument The media services details
     */
    @JvmName("hontolcdfxomblks")
    public suspend
    fun mediaServices(argument: suspend MediaServicesForPutRequestArgsBuilder.() -> Unit) {
        val toBeMapped = MediaServicesForPutRequestArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mediaServices = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wugfyguutvncgqer")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rsvprtuxdlxhqjeb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fakvxkciuqcooxnx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountId = accountId,
        accountName = accountName,
        identity = identity,
        location = location,
        mediaServices = mediaServices,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
