@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoindexer.kotlin.inputs

import com.pulumi.azurenative.videoindexer.inputs.MediaServicesForPutRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The media services details
 * @property resourceId The media services resource id
 * @property userAssignedIdentity The user assigned identity to be used to grant permissions
 */
public data class MediaServicesForPutRequestArgs(
    public val resourceId: Output<String>? = null,
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoindexer.inputs.MediaServicesForPutRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.videoindexer.inputs.MediaServicesForPutRequestArgs =
        com.pulumi.azurenative.videoindexer.inputs.MediaServicesForPutRequestArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MediaServicesForPutRequestArgs].
 */
@PulumiTagMarker
public class MediaServicesForPutRequestArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The media services resource id
     */
    @JvmName("vkyfjaujjsvfgruh")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The user assigned identity to be used to grant permissions
     */
    @JvmName("mamvrhatauixqcrb")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The media services resource id
     */
    @JvmName("nirtrlwkyfasxbso")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The user assigned identity to be used to grant permissions
     */
    @JvmName("wrnsaycuoepynfcf")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): MediaServicesForPutRequestArgs = MediaServicesForPutRequestArgs(
        resourceId = resourceId,
        userAssignedIdentity = userAssignedIdentity,
    )
}
