@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin

import com.pulumi.azurenative.virtualmachineimages.VirtualMachineImageTemplateArgs.builder
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.ImageTemplateIdentityArgs
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.ImageTemplateIdentityArgsBuilder
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.ImageTemplatePropertiesOptimizeArgs
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.ImageTemplatePropertiesOptimizeArgsBuilder
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.ImageTemplatePropertiesValidateArgs
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.ImageTemplatePropertiesValidateArgsBuilder
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.ImageTemplateVmProfileArgs
import com.pulumi.azurenative.virtualmachineimages.kotlin.inputs.ImageTemplateVmProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Image template is an ARM resource managed by Microsoft.VirtualMachineImages provider
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-02-14.
 * Other available API versions: 2018-02-01-preview, 2019-05-01-preview, 2023-07-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:virtualmachineimages:VirtualMachineImageTemplate myImageTemplate /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VirtualMachineImages/imageTemplates/{imageTemplateName}
 * ```
 * @property buildTimeoutInMinutes Maximum duration to wait while building the image template (includes all customizations, optimization, validations, and distributions). Omit or specify 0 to use the default (4 hours).
 * @property customize Specifies the properties used to describe the customization steps of the image, like Image source etc
 * @property distribute The distribution targets where the image output needs to go to.
 * @property identity The identity of the image template, if configured.
 * @property imageTemplateName The name of the image Template
 * @property location The geo-location where the resource lives
 * @property optimize Specifies optimization to be performed on image.
 * @property resourceGroupName The name of the resource group.
 * @property source Specifies the properties used to describe the source image.
 * @property stagingResourceGroup The staging resource group id in the same subscription as the image template that will be used to build the image. If this field is empty, a resource group with a random name will be created. If the resource group specified in this field doesn't exist, it will be created with the same name. If the resource group specified exists, it must be empty and in the same region as the image template. The resource group created will be deleted during template deletion if this field is empty or the resource group specified doesn't exist, but if the resource group specified exists the resources created in the resource group will be deleted during template deletion and the resource group itself will remain.
 * @property tags Resource tags.
 * @property validate Configuration options and list of validations to be performed on the resulting image.
 * @property vmProfile Describes how virtual machine is set up to build images
 */
public data class VirtualMachineImageTemplateArgs(
    public val buildTimeoutInMinutes: Output<Int>? = null,
    public val customize: Output<List<Any>>? = null,
    public val distribute: Output<List<Any>>? = null,
    public val identity: Output<ImageTemplateIdentityArgs>? = null,
    public val imageTemplateName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val optimize: Output<ImageTemplatePropertiesOptimizeArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<Any>? = null,
    public val stagingResourceGroup: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val validate: Output<ImageTemplatePropertiesValidateArgs>? = null,
    public val vmProfile: Output<ImageTemplateVmProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.VirtualMachineImageTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.virtualmachineimages.VirtualMachineImageTemplateArgs =
        com.pulumi.azurenative.virtualmachineimages.VirtualMachineImageTemplateArgs.builder()
            .buildTimeoutInMinutes(buildTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .customize(customize?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .distribute(distribute?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageTemplateName(imageTemplateName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .optimize(optimize?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .stagingResourceGroup(stagingResourceGroup?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .validate(validate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmProfile(vmProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachineImageTemplateArgs].
 */
@PulumiTagMarker
public class VirtualMachineImageTemplateArgsBuilder internal constructor() {
    private var buildTimeoutInMinutes: Output<Int>? = null

    private var customize: Output<List<Any>>? = null

    private var distribute: Output<List<Any>>? = null

    private var identity: Output<ImageTemplateIdentityArgs>? = null

    private var imageTemplateName: Output<String>? = null

    private var location: Output<String>? = null

    private var optimize: Output<ImageTemplatePropertiesOptimizeArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<Any>? = null

    private var stagingResourceGroup: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var validate: Output<ImageTemplatePropertiesValidateArgs>? = null

    private var vmProfile: Output<ImageTemplateVmProfileArgs>? = null

    /**
     * @param value Maximum duration to wait while building the image template (includes all customizations, optimization, validations, and distributions). Omit or specify 0 to use the default (4 hours).
     */
    @JvmName("usdgbjbpmrumvlia")
    public suspend fun buildTimeoutInMinutes(`value`: Output<Int>) {
        this.buildTimeoutInMinutes = value
    }

    /**
     * @param value Specifies the properties used to describe the customization steps of the image, like Image source etc
     */
    @JvmName("wclmueplcyxodivt")
    public suspend fun customize(`value`: Output<List<Any>>) {
        this.customize = value
    }

    @JvmName("rbknqagclbcqrvuw")
    public suspend fun customize(vararg values: Output<Any>) {
        this.customize = Output.all(values.asList())
    }

    /**
     * @param values Specifies the properties used to describe the customization steps of the image, like Image source etc
     */
    @JvmName("awkknhxsvmdhetnk")
    public suspend fun customize(values: List<Output<Any>>) {
        this.customize = Output.all(values)
    }

    /**
     * @param value The distribution targets where the image output needs to go to.
     */
    @JvmName("xypbapeaeoerxnrv")
    public suspend fun distribute(`value`: Output<List<Any>>) {
        this.distribute = value
    }

    @JvmName("nngjcohtnxsltavq")
    public suspend fun distribute(vararg values: Output<Any>) {
        this.distribute = Output.all(values.asList())
    }

    /**
     * @param values The distribution targets where the image output needs to go to.
     */
    @JvmName("wbihmbekpwobhpii")
    public suspend fun distribute(values: List<Output<Any>>) {
        this.distribute = Output.all(values)
    }

    /**
     * @param value The identity of the image template, if configured.
     */
    @JvmName("skevsmafwljdbbbj")
    public suspend fun identity(`value`: Output<ImageTemplateIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The name of the image Template
     */
    @JvmName("eebhtutdfxeqgdra")
    public suspend fun imageTemplateName(`value`: Output<String>) {
        this.imageTemplateName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yhkdgtixrfjlvfli")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies optimization to be performed on image.
     */
    @JvmName("cgtwhimomxrnvcnw")
    public suspend fun optimize(`value`: Output<ImageTemplatePropertiesOptimizeArgs>) {
        this.optimize = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qxangvyedsqtrooe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the properties used to describe the source image.
     */
    @JvmName("fsvfrmofcuqhtnwt")
    public suspend fun source(`value`: Output<Any>) {
        this.source = value
    }

    /**
     * @param value The staging resource group id in the same subscription as the image template that will be used to build the image. If this field is empty, a resource group with a random name will be created. If the resource group specified in this field doesn't exist, it will be created with the same name. If the resource group specified exists, it must be empty and in the same region as the image template. The resource group created will be deleted during template deletion if this field is empty or the resource group specified doesn't exist, but if the resource group specified exists the resources created in the resource group will be deleted during template deletion and the resource group itself will remain.
     */
    @JvmName("ynnnuqejfucwddpj")
    public suspend fun stagingResourceGroup(`value`: Output<String>) {
        this.stagingResourceGroup = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lilfnkyktddvsrhl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration options and list of validations to be performed on the resulting image.
     */
    @JvmName("rnmdsbinivotthgc")
    public suspend fun validate(`value`: Output<ImageTemplatePropertiesValidateArgs>) {
        this.validate = value
    }

    /**
     * @param value Describes how virtual machine is set up to build images
     */
    @JvmName("cbjamluvgxkjxdce")
    public suspend fun vmProfile(`value`: Output<ImageTemplateVmProfileArgs>) {
        this.vmProfile = value
    }

    /**
     * @param value Maximum duration to wait while building the image template (includes all customizations, optimization, validations, and distributions). Omit or specify 0 to use the default (4 hours).
     */
    @JvmName("vydouaffmgmlsbal")
    public suspend fun buildTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildTimeoutInMinutes = mapped
    }

    /**
     * @param value Specifies the properties used to describe the customization steps of the image, like Image source etc
     */
    @JvmName("kyvkvfxixgsscrsq")
    public suspend fun customize(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customize = mapped
    }

    /**
     * @param values Specifies the properties used to describe the customization steps of the image, like Image source etc
     */
    @JvmName("vgqvsvywuklelvbx")
    public suspend fun customize(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customize = mapped
    }

    /**
     * @param value The distribution targets where the image output needs to go to.
     */
    @JvmName("imqipwtitknsywxi")
    public suspend fun distribute(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distribute = mapped
    }

    /**
     * @param values The distribution targets where the image output needs to go to.
     */
    @JvmName("omiytvtumdsxnfft")
    public suspend fun distribute(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.distribute = mapped
    }

    /**
     * @param value The identity of the image template, if configured.
     */
    @JvmName("cbounmqsnovwkmnf")
    public suspend fun identity(`value`: ImageTemplateIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the image template, if configured.
     */
    @JvmName("vyugskdoatgejphh")
    public suspend fun identity(argument: suspend ImageTemplateIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ImageTemplateIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name of the image Template
     */
    @JvmName("penqyjaqhsoyohva")
    public suspend fun imageTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTemplateName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rcilgyxiqsjslfac")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies optimization to be performed on image.
     */
    @JvmName("qylvasaurbrbrlcc")
    public suspend fun optimize(`value`: ImageTemplatePropertiesOptimizeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimize = mapped
    }

    /**
     * @param argument Specifies optimization to be performed on image.
     */
    @JvmName("gfihtqgtjjygacrf")
    public suspend
    fun optimize(argument: suspend ImageTemplatePropertiesOptimizeArgsBuilder.() -> Unit) {
        val toBeMapped = ImageTemplatePropertiesOptimizeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.optimize = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ydiwqthiqmcstwoy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the properties used to describe the source image.
     */
    @JvmName("ossperydiochvxuo")
    public suspend fun source(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The staging resource group id in the same subscription as the image template that will be used to build the image. If this field is empty, a resource group with a random name will be created. If the resource group specified in this field doesn't exist, it will be created with the same name. If the resource group specified exists, it must be empty and in the same region as the image template. The resource group created will be deleted during template deletion if this field is empty or the resource group specified doesn't exist, but if the resource group specified exists the resources created in the resource group will be deleted during template deletion and the resource group itself will remain.
     */
    @JvmName("mhrwxwmgwqemnjbf")
    public suspend fun stagingResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stagingResourceGroup = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vjqojrcujeumgnwr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wypvdivxrpnvudok")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration options and list of validations to be performed on the resulting image.
     */
    @JvmName("xybjdyhppaevptio")
    public suspend fun validate(`value`: ImageTemplatePropertiesValidateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validate = mapped
    }

    /**
     * @param argument Configuration options and list of validations to be performed on the resulting image.
     */
    @JvmName("wrykffrlcvmiivhx")
    public suspend
    fun validate(argument: suspend ImageTemplatePropertiesValidateArgsBuilder.() -> Unit) {
        val toBeMapped = ImageTemplatePropertiesValidateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validate = mapped
    }

    /**
     * @param value Describes how virtual machine is set up to build images
     */
    @JvmName("tjrmpmobafyqfpnf")
    public suspend fun vmProfile(`value`: ImageTemplateVmProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmProfile = mapped
    }

    /**
     * @param argument Describes how virtual machine is set up to build images
     */
    @JvmName("tqdscygonvnildps")
    public suspend fun vmProfile(argument: suspend ImageTemplateVmProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ImageTemplateVmProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmProfile = mapped
    }

    internal fun build(): VirtualMachineImageTemplateArgs = VirtualMachineImageTemplateArgs(
        buildTimeoutInMinutes = buildTimeoutInMinutes,
        customize = customize,
        distribute = distribute,
        identity = identity,
        imageTemplateName = imageTemplateName,
        location = location,
        optimize = optimize,
        resourceGroupName = resourceGroupName,
        source = source,
        stagingResourceGroup = stagingResourceGroup,
        tags = tags,
        validate = validate,
        vmProfile = vmProfile,
    )
}
