@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the storage account type to be used to store the image in this region. Omit to use the default (Standard_LRS).
 */
public enum class SharedImageStorageAccountType(
    public val javaValue:
    com.pulumi.azurenative.virtualmachineimages.enums.SharedImageStorageAccountType,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.enums.SharedImageStorageAccountType> {
    Standard_LRS(com.pulumi.azurenative.virtualmachineimages.enums.SharedImageStorageAccountType.Standard_LRS),
    Standard_ZRS(com.pulumi.azurenative.virtualmachineimages.enums.SharedImageStorageAccountType.Standard_ZRS),
    Premium_LRS(com.pulumi.azurenative.virtualmachineimages.enums.SharedImageStorageAccountType.Premium_LRS),
    ;

    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.enums.SharedImageStorageAccountType = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.enums.SharedImageStorageAccountType):
            SharedImageStorageAccountType =
            SharedImageStorageAccountType.values().first { it.javaValue == javaType }
    }
}
