@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesOptimizeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Specifies optimization to be performed on image.
 * @property vmBoot Optimization is applied on the image for a faster VM boot.
 */
public data class ImageTemplatePropertiesOptimizeArgs(
    public val vmBoot: Output<ImageTemplatePropertiesVmBootArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesOptimizeArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesOptimizeArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplatePropertiesOptimizeArgs.builder()
            .vmBoot(vmBoot?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ImageTemplatePropertiesOptimizeArgs].
 */
@PulumiTagMarker
public class ImageTemplatePropertiesOptimizeArgsBuilder internal constructor() {
    private var vmBoot: Output<ImageTemplatePropertiesVmBootArgs>? = null

    /**
     * @param value Optimization is applied on the image for a faster VM boot.
     */
    @JvmName("fwmitjvyggdvcgqc")
    public suspend fun vmBoot(`value`: Output<ImageTemplatePropertiesVmBootArgs>) {
        this.vmBoot = value
    }

    /**
     * @param value Optimization is applied on the image for a faster VM boot.
     */
    @JvmName("vnnnftrnhyvkurnh")
    public suspend fun vmBoot(`value`: ImageTemplatePropertiesVmBootArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmBoot = mapped
    }

    /**
     * @param argument Optimization is applied on the image for a faster VM boot.
     */
    @JvmName("uoibsflbqoquwggp")
    public suspend fun vmBoot(argument: suspend ImageTemplatePropertiesVmBootArgsBuilder.() -> Unit) {
        val toBeMapped = ImageTemplatePropertiesVmBootArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmBoot = mapped
    }

    internal fun build(): ImageTemplatePropertiesOptimizeArgs = ImageTemplatePropertiesOptimizeArgs(
        vmBoot = vmBoot,
    )
}
