@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateRestartCustomizerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reboots a VM and waits for it to come back online (Windows). Corresponds to Packer windows-restart provisioner
 * @property name Friendly Name to provide context on what this customization step does
 * @property restartCheckCommand Command to check if restart succeeded [Default: '']
 * @property restartCommand Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
 * @property restartTimeout Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
 * @property type The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
 * Expected value is 'WindowsRestart'.
 */
public data class ImageTemplateRestartCustomizerArgs(
    public val name: Output<String>? = null,
    public val restartCheckCommand: Output<String>? = null,
    public val restartCommand: Output<String>? = null,
    public val restartTimeout: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateRestartCustomizerArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateRestartCustomizerArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateRestartCustomizerArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .restartCheckCommand(restartCheckCommand?.applyValue({ args0 -> args0 }))
            .restartCommand(restartCommand?.applyValue({ args0 -> args0 }))
            .restartTimeout(restartTimeout?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplateRestartCustomizerArgs].
 */
@PulumiTagMarker
public class ImageTemplateRestartCustomizerArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var restartCheckCommand: Output<String>? = null

    private var restartCommand: Output<String>? = null

    private var restartTimeout: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Friendly Name to provide context on what this customization step does
     */
    @JvmName("iaurrpintstsupwd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Command to check if restart succeeded [Default: '']
     */
    @JvmName("rahcinpikyjqfxdu")
    public suspend fun restartCheckCommand(`value`: Output<String>) {
        this.restartCheckCommand = value
    }

    /**
     * @param value Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
     */
    @JvmName("fmuofogqdyulcekv")
    public suspend fun restartCommand(`value`: Output<String>) {
        this.restartCommand = value
    }

    /**
     * @param value Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
     */
    @JvmName("tgyvlwufgpgckjrm")
    public suspend fun restartTimeout(`value`: Output<String>) {
        this.restartTimeout = value
    }

    /**
     * @param value The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
     * Expected value is 'WindowsRestart'.
     */
    @JvmName("lxqjxaupkgvytvbr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Friendly Name to provide context on what this customization step does
     */
    @JvmName("ykthefcvuggbojip")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Command to check if restart succeeded [Default: '']
     */
    @JvmName("akxfsrvbjthlwrjk")
    public suspend fun restartCheckCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartCheckCommand = mapped
    }

    /**
     * @param value Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
     */
    @JvmName("bhbnuxayyxhxonqh")
    public suspend fun restartCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartCommand = mapped
    }

    /**
     * @param value Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
     */
    @JvmName("ubcnnsvlcxvmhvkw")
    public suspend fun restartTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartTimeout = mapped
    }

    /**
     * @param value The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
     * Expected value is 'WindowsRestart'.
     */
    @JvmName("sourovyfylunysrn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ImageTemplateRestartCustomizerArgs = ImageTemplateRestartCustomizerArgs(
        name = name,
        restartCheckCommand = restartCheckCommand,
        restartCommand = restartCommand,
        restartTimeout = restartTimeout,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
