@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateShellCustomizerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Runs a shell script during the customization phase (Linux). Corresponds to Packer shell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
 * @property inline Array of shell commands to execute
 * @property name Friendly Name to provide context on what this customization step does
 * @property scriptUri URI of the shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
 * @property sha256Checksum SHA256 checksum of the shell script provided in the scriptUri field
 * @property type The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
 * Expected value is 'Shell'.
 */
public data class ImageTemplateShellCustomizerArgs(
    public val `inline`: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val scriptUri: Output<String>? = null,
    public val sha256Checksum: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateShellCustomizerArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateShellCustomizerArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateShellCustomizerArgs.builder()
            .`inline`(`inline`?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .scriptUri(scriptUri?.applyValue({ args0 -> args0 }))
            .sha256Checksum(sha256Checksum?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageTemplateShellCustomizerArgs].
 */
@PulumiTagMarker
public class ImageTemplateShellCustomizerArgsBuilder internal constructor() {
    private var `inline`: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var scriptUri: Output<String>? = null

    private var sha256Checksum: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Array of shell commands to execute
     */
    @JvmName("axsufuhnvseabpia")
    public suspend fun `inline`(`value`: Output<List<String>>) {
        this.`inline` = value
    }

    @JvmName("hcfvaprtqxelxwrm")
    public suspend fun `inline`(vararg values: Output<String>) {
        this.`inline` = Output.all(values.asList())
    }

    /**
     * @param values Array of shell commands to execute
     */
    @JvmName("dfqwcmpawixwagns")
    public suspend fun `inline`(values: List<Output<String>>) {
        this.`inline` = Output.all(values)
    }

    /**
     * @param value Friendly Name to provide context on what this customization step does
     */
    @JvmName("eqcsbysfsnvcksej")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value URI of the shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
     */
    @JvmName("nlntcgiksrfxtckc")
    public suspend fun scriptUri(`value`: Output<String>) {
        this.scriptUri = value
    }

    /**
     * @param value SHA256 checksum of the shell script provided in the scriptUri field
     */
    @JvmName("oknsdopxsbnxfigq")
    public suspend fun sha256Checksum(`value`: Output<String>) {
        this.sha256Checksum = value
    }

    /**
     * @param value The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
     * Expected value is 'Shell'.
     */
    @JvmName("iujuftwmofmrfoif")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Array of shell commands to execute
     */
    @JvmName("metntregquprlkja")
    public suspend fun `inline`(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`inline` = mapped
    }

    /**
     * @param values Array of shell commands to execute
     */
    @JvmName("uyhunrtljbvapmvy")
    public suspend fun `inline`(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`inline` = mapped
    }

    /**
     * @param value Friendly Name to provide context on what this customization step does
     */
    @JvmName("aiomdrabhhqhrroi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value URI of the shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
     */
    @JvmName("tuaesypcxwhnnamk")
    public suspend fun scriptUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptUri = mapped
    }

    /**
     * @param value SHA256 checksum of the shell script provided in the scriptUri field
     */
    @JvmName("lpbhqntyopdyojkp")
    public suspend fun sha256Checksum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sha256Checksum = mapped
    }

    /**
     * @param value The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
     * Expected value is 'Shell'.
     */
    @JvmName("phyapcmsuwwaweab")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ImageTemplateShellCustomizerArgs = ImageTemplateShellCustomizerArgs(
        `inline` = `inline`,
        name = name,
        scriptUri = scriptUri,
        sha256Checksum = sha256Checksum,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
