@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.inputs

import com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateVmProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the virtual machines used to build and validate images
 * @property osDiskSizeGB Size of the OS disk in GB. Omit or specify 0 to use Azure's default OS disk size.
 * @property userAssignedIdentities Optional array of resource IDs of user assigned managed identities to be configured on the build VM and validation VM. This may include the identity of the image template.
 * @property vmSize Size of the virtual machine used to build, customize and capture images. Omit or specify empty string to use the default (Standard_D1_v2 for Gen1 images and Standard_D2ds_v4 for Gen2 images).
 * @property vnetConfig Optional configuration of the virtual network to use to deploy the build VM and validation VM in. Omit if no specific virtual network needs to be used.
 */
public data class ImageTemplateVmProfileArgs(
    public val osDiskSizeGB: Output<Int>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
    public val vmSize: Output<String>? = null,
    public val vnetConfig: Output<VirtualNetworkConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateVmProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateVmProfileArgs =
        com.pulumi.azurenative.virtualmachineimages.inputs.ImageTemplateVmProfileArgs.builder()
            .osDiskSizeGB(osDiskSizeGB?.applyValue({ args0 -> args0 }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .vmSize(vmSize?.applyValue({ args0 -> args0 }))
            .vnetConfig(vnetConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ImageTemplateVmProfileArgs].
 */
@PulumiTagMarker
public class ImageTemplateVmProfileArgsBuilder internal constructor() {
    private var osDiskSizeGB: Output<Int>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    private var vmSize: Output<String>? = null

    private var vnetConfig: Output<VirtualNetworkConfigArgs>? = null

    /**
     * @param value Size of the OS disk in GB. Omit or specify 0 to use Azure's default OS disk size.
     */
    @JvmName("aiwobrmkoujykqsu")
    public suspend fun osDiskSizeGB(`value`: Output<Int>) {
        this.osDiskSizeGB = value
    }

    /**
     * @param value Optional array of resource IDs of user assigned managed identities to be configured on the build VM and validation VM. This may include the identity of the image template.
     */
    @JvmName("wycvrfeuqrnkpxuv")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("ffoekgohsypqquwf")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values Optional array of resource IDs of user assigned managed identities to be configured on the build VM and validation VM. This may include the identity of the image template.
     */
    @JvmName("yficnlbxaoyaikkt")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Size of the virtual machine used to build, customize and capture images. Omit or specify empty string to use the default (Standard_D1_v2 for Gen1 images and Standard_D2ds_v4 for Gen2 images).
     */
    @JvmName("yyqfrmcdlblamysm")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value Optional configuration of the virtual network to use to deploy the build VM and validation VM in. Omit if no specific virtual network needs to be used.
     */
    @JvmName("kxwxgteihdhqwxrm")
    public suspend fun vnetConfig(`value`: Output<VirtualNetworkConfigArgs>) {
        this.vnetConfig = value
    }

    /**
     * @param value Size of the OS disk in GB. Omit or specify 0 to use Azure's default OS disk size.
     */
    @JvmName("tkuovswarlxqxslb")
    public suspend fun osDiskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDiskSizeGB = mapped
    }

    /**
     * @param value Optional array of resource IDs of user assigned managed identities to be configured on the build VM and validation VM. This may include the identity of the image template.
     */
    @JvmName("okrrcecbumgndlqe")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values Optional array of resource IDs of user assigned managed identities to be configured on the build VM and validation VM. This may include the identity of the image template.
     */
    @JvmName("prtlbfpdaaoqpouc")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param value Size of the virtual machine used to build, customize and capture images. Omit or specify empty string to use the default (Standard_D1_v2 for Gen1 images and Standard_D2ds_v4 for Gen2 images).
     */
    @JvmName("olnsaeursdsfotsv")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value Optional configuration of the virtual network to use to deploy the build VM and validation VM in. Omit if no specific virtual network needs to be used.
     */
    @JvmName("ldsemwgtmmfwnpgx")
    public suspend fun vnetConfig(`value`: VirtualNetworkConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetConfig = mapped
    }

    /**
     * @param argument Optional configuration of the virtual network to use to deploy the build VM and validation VM in. Omit if no specific virtual network needs to be used.
     */
    @JvmName("ycpeqxkvaafqfquo")
    public suspend fun vnetConfig(argument: suspend VirtualNetworkConfigArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vnetConfig = mapped
    }

    internal fun build(): ImageTemplateVmProfileArgs = ImageTemplateVmProfileArgs(
        osDiskSizeGB = osDiskSizeGB,
        userAssignedIdentities = userAssignedIdentities,
        vmSize = vmSize,
        vnetConfig = vnetConfig,
    )
}
