@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Identity for the image template.
 * @property type The type of identity used for the image template. The type 'None' will remove any identities from the image template.
 * @property userAssignedIdentities The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
 */
public data class ImageTemplateIdentityResponse(
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserAssignedIdentityResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.ImageTemplateIdentityResponse):
            ImageTemplateIdentityResponse = ImageTemplateIdentityResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.virtualmachineimages.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
