@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.virtualmachineimages.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the status of a trigger
 * @property code The status code.
 * @property message The detailed status message, including for alerts and error messages.
 * @property time The time of the status.
 */
public data class TriggerStatusResponse(
    public val code: String,
    public val message: String,
    public val time: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.virtualmachineimages.outputs.TriggerStatusResponse):
            TriggerStatusResponse = TriggerStatusResponse(
            code = javaType.code(),
            message = javaType.message(),
            time = javaType.time(),
        )
    }
}
