@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.visualstudio.kotlin

import com.pulumi.azurenative.visualstudio.AccountArgs.builder
import com.pulumi.azurenative.visualstudio.kotlin.enums.AccountResourceRequestOperationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The response to an account resource GET request.
 * Azure REST API version: 2017-11-01-preview. Prior API version in Azure Native 1.x: 2014-04-01-preview.
 * ## Example Usage
 * ### Create an account resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.VisualStudio.Account("account", new()
 *     {
 *         AccountName = "Example",
 *         Location = "Central US",
 *         OperationType = "create",
 *         Properties = null,
 *         ResourceGroupName = "VS-Example-Group",
 *         ResourceName = "Example",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/visualstudio/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := visualstudio.NewAccount(ctx, "account", &visualstudio.AccountArgs{
 * 			AccountName:       pulumi.String("Example"),
 * 			Location:          pulumi.String("Central US"),
 * 			OperationType:     pulumi.String("create"),
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("VS-Example-Group"),
 * 			ResourceName:      pulumi.String("Example"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.visualstudio.Account;
 * import com.pulumi.azurenative.visualstudio.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("Example")
 *             .location("Central US")
 *             .operationType("create")
 *             .properties()
 *             .resourceGroupName("VS-Example-Group")
 *             .resourceName("Example")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:visualstudio:Account VS-Example-Group /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.visualstudio/account/{resourceName}
 * ```
 * @property accountName The account name.
 * @property location The Azure instance location.
 * @property operationType The type of the operation.
 * @property properties The custom properties of the resource.
 * @property resourceGroupName Name of the resource group within the Azure subscription.
 * @property resourceName Name of the resource.
 * @property tags The custom tags of the resource.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val operationType: Output<Either<String, AccountResourceRequestOperationType>>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.visualstudio.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.visualstudio.AccountArgs =
        com.pulumi.azurenative.visualstudio.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .operationType(
                operationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var location: Output<String>? = null

    private var operationType: Output<Either<String, AccountResourceRequestOperationType>>? = null

    private var properties: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The account name.
     */
    @JvmName("cjksfyawxpmprbma")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The Azure instance location.
     */
    @JvmName("qylobhpiknwtisgy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The type of the operation.
     */
    @JvmName("oitfcuxvtpshjyiv")
    public suspend
    fun operationType(`value`: Output<Either<String, AccountResourceRequestOperationType>>) {
        this.operationType = value
    }

    /**
     * @param value The custom properties of the resource.
     */
    @JvmName("gpjcepjkwogbbrke")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group within the Azure subscription.
     */
    @JvmName("vgpdblyoeyiuemxu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("dqxfotnrwflvwliw")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The custom tags of the resource.
     */
    @JvmName("cbffntivltqpdiwq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The account name.
     */
    @JvmName("ysmsujvarseourxy")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The Azure instance location.
     */
    @JvmName("foeovejjsjkspacb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The type of the operation.
     */
    @JvmName("kuhksvsotiuadldl")
    public suspend fun operationType(`value`: Either<String, AccountResourceRequestOperationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value The type of the operation.
     */
    @JvmName("cvwvaukyhgwurxfw")
    public fun operationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccountResourceRequestOperationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value The type of the operation.
     */
    @JvmName("wkngxvktwuvndubx")
    public fun operationType(`value`: AccountResourceRequestOperationType) {
        val toBeMapped = Either.ofRight<String, AccountResourceRequestOperationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operationType = mapped
    }

    /**
     * @param value The custom properties of the resource.
     */
    @JvmName("jmggmxloyunumeic")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The custom properties of the resource.
     */
    @JvmName("cgggualnrgogphlv")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group within the Azure subscription.
     */
    @JvmName("udgkdgwafgwfukte")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("wpwuqofxxyeiseyx")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The custom tags of the resource.
     */
    @JvmName("ginsncmsvpcytlyh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The custom tags of the resource.
     */
    @JvmName("ebdvjjdfbjaomymq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        location = location,
        operationType = operationType,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
