@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.visualstudio.kotlin.inputs

import com.pulumi.azurenative.visualstudio.inputs.GetAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Name of the resource group within the Azure subscription.
 * @property resourceName Name of the resource.
 */
public data class GetAccountPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.visualstudio.inputs.GetAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.visualstudio.inputs.GetAccountPlainArgs =
        com.pulumi.azurenative.visualstudio.inputs.GetAccountPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountPlainArgs].
 */
@PulumiTagMarker
public class GetAccountPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Name of the resource group within the Azure subscription.
     */
    @JvmName("mskgpekhnqsgdyvl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("fmlihvqdvearrspt")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetAccountPlainArgs = GetAccountPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
