@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.GetVirtualMachinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group
 * @property virtualMachineName virtual machine name
 */
public data class GetVirtualMachinePlainArgs(
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.GetVirtualMachinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.inputs.GetVirtualMachinePlainArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.GetVirtualMachinePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachinePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachinePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value The name of the resource group
     */
    @JvmName("ssevowxqgvqnnfoo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value virtual machine name
     */
    @JvmName("yfbegfkmnbsykhvm")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetVirtualMachinePlainArgs = GetVirtualMachinePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
