@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The purchase SKU for CloudSimple paid resources
 * @property capacity The capacity of the SKU
 * @property description dedicatedCloudNode example: 8 x Ten-Core Intel® Xeon® Processor E5-2640 v4 2.40GHz 25MB Cache (90W); 12 x 64GB PC4-19200 2400MHz DDR4 ECC Registered DIMM, ...
 * @property family If the service has different generations of hardware, for the same SKU, then that can be captured here
 * @property name The name of the SKU for VMWare CloudSimple Node
 * @property tier The tier of the SKU
 */
public data class SkuArgs(
    public val capacity: Output<String>? = null,
    public val description: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.inputs.SkuArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<String>? = null

    private var description: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The capacity of the SKU
     */
    @JvmName("ejtlavvrwwkyrsfe")
    public suspend fun capacity(`value`: Output<String>) {
        this.capacity = value
    }

    /**
     * @param value dedicatedCloudNode example: 8 x Ten-Core Intel® Xeon® Processor E5-2640 v4 2.40GHz 25MB Cache (90W); 12 x 64GB PC4-19200 2400MHz DDR4 ECC Registered DIMM, ...
     */
    @JvmName("lyunjcoauyjoplpj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here
     */
    @JvmName("xavwfqwukyjxlgbc")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the SKU for VMWare CloudSimple Node
     */
    @JvmName("jcgdcxechlwxistv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The tier of the SKU
     */
    @JvmName("wshayqwymoqyxibe")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The capacity of the SKU
     */
    @JvmName("fahbdwbaxtftqrln")
    public suspend fun capacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value dedicatedCloudNode example: 8 x Ten-Core Intel® Xeon® Processor E5-2640 v4 2.40GHz 25MB Cache (90W); 12 x 64GB PC4-19200 2400MHz DDR4 ECC Registered DIMM, ...
     */
    @JvmName("upxqfqsyjojfjwpc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here
     */
    @JvmName("rnysccpduknusfbh")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the SKU for VMWare CloudSimple Node
     */
    @JvmName("egchmrumpxbdiwnr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The tier of the SKU
     */
    @JvmName("kpjegjqosvkdsjwp")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        description = description,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
