@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.inputs

import com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual network model
 * @property id virtual network id (privateCloudId:vsphereId)
 */
public data class VirtualNetworkArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNetworkArgs =
        com.pulumi.azurenative.vmwarecloudsimple.inputs.VirtualNetworkArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkArgs].
 */
@PulumiTagMarker
public class VirtualNetworkArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value virtual network id (privateCloudId:vsphereId)
     */
    @JvmName("uslakqwgsdihaweh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value virtual network id (privateCloudId:vsphereId)
     */
    @JvmName("sqgxvmdrxcexmdpc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualNetworkArgs = VirtualNetworkArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
