@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource pool model
 * @property fullName Hierarchical resource pool name
 * @property id resource pool id (privateCloudId:vsphereId)
 * @property location Azure region
 * @property name {ResourcePoolName}
 * @property privateCloudId The Private Cloud Id
 * @property type {resourceProviderNamespace}/{resourceType}
 */
public data class ResourcePoolResponse(
    public val fullName: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateCloudId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.ResourcePoolResponse):
            ResourcePoolResponse = ResourcePoolResponse(
            fullName = javaType.fullName(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateCloudId = javaType.privateCloudId(),
            type = javaType.type(),
        )
    }
}
