@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.vmwarecloudsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The purchase SKU for CloudSimple paid resources
 * @property capacity The capacity of the SKU
 * @property description dedicatedCloudNode example: 8 x Ten-Core Intel® Xeon® Processor E5-2640 v4 2.40GHz 25MB Cache (90W); 12 x 64GB PC4-19200 2400MHz DDR4 ECC Registered DIMM, ...
 * @property family If the service has different generations of hardware, for the same SKU, then that can be captured here
 * @property name The name of the SKU for VMWare CloudSimple Node
 * @property tier The tier of the SKU
 */
public data class SkuResponse(
    public val capacity: String? = null,
    public val description: String? = null,
    public val family: String? = null,
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.vmwarecloudsimple.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
