@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin

import com.pulumi.azurenative.voiceservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.voiceservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Contact].
 */
@PulumiTagMarker
public class ContactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContactArgs = ContactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContactArgsBuilder.() -> Unit) {
        val builder = ContactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Contact {
        val builtJavaResource = com.pulumi.azurenative.voiceservices.Contact(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Contact(builtJavaResource)
    }
}

/**
 * A Contact resource
 * Azure REST API version: 2022-12-01-preview. Prior API version in Azure Native 1.x: 2022-12-01-preview.
 * ## Example Usage
 * ### CreateContactResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contact = new AzureNative.VoiceServices.Contact("contact", new()
 *     {
 *         CommunicationsGatewayName = "myname",
 *         ContactName = "John Smith",
 *         Email = "johnsmith@example.com",
 *         Location = "useast",
 *         PhoneNumber = "+1-555-1234",
 *         ResourceGroupName = "testrg",
 *         Role = "Network Manager",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/voiceservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := voiceservices.NewContact(ctx, "contact", &voiceservices.ContactArgs{
 * 			CommunicationsGatewayName: pulumi.String("myname"),
 * 			ContactName:               pulumi.String("John Smith"),
 * 			Email:                     pulumi.String("johnsmith@example.com"),
 * 			Location:                  pulumi.String("useast"),
 * 			PhoneNumber:               pulumi.String("+1-555-1234"),
 * 			ResourceGroupName:         pulumi.String("testrg"),
 * 			Role:                      pulumi.String("Network Manager"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.voiceservices.Contact;
 * import com.pulumi.azurenative.voiceservices.ContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contact = new Contact("contact", ContactArgs.builder()
 *             .communicationsGatewayName("myname")
 *             .contactName("John Smith")
 *             .email("johnsmith@example.com")
 *             .location("useast")
 *             .phoneNumber("+1-555-1234")
 *             .resourceGroupName("testrg")
 *             .role("Network Manager")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:voiceservices:Contact name2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VoiceServices/communicationsGateways/{communicationsGatewayName}/contacts/{contactName}
 * ```
 */
public class Contact internal constructor(
    override val javaResource: com.pulumi.azurenative.voiceservices.Contact,
) : KotlinCustomResource(javaResource, ContactMapper) {
    /**
     * Full name of contact
     */
    public val contactName: Output<String>
        get() = javaResource.contactName().applyValue({ args0 -> args0 })

    /**
     * Email address of contact
     */
    public val email: Output<String>
        get() = javaResource.email().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Telephone number of contact
     */
    public val phoneNumber: Output<String>
        get() = javaResource.phoneNumber().applyValue({ args0 -> args0 })

    /**
     * Resource provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Job title of contact
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContactMapper : ResourceMapper<Contact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.voiceservices.Contact::class == javaResource::class

    override fun map(javaResource: Resource): Contact = Contact(
        javaResource as
            com.pulumi.azurenative.voiceservices.Contact,
    )
}

/**
 * @see [Contact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Contact].
 */
public suspend fun contact(name: String, block: suspend ContactResourceBuilder.() -> Unit):
    Contact {
    val builder = ContactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Contact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contact(name: String): Contact {
    val builder = ContactResourceBuilder()
    builder.name(name)
    return builder.build()
}
