@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin

import com.pulumi.azurenative.voiceservices.ContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Contact resource
 * Azure REST API version: 2022-12-01-preview. Prior API version in Azure Native 1.x: 2022-12-01-preview.
 * ## Example Usage
 * ### CreateContactResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contact = new AzureNative.VoiceServices.Contact("contact", new()
 *     {
 *         CommunicationsGatewayName = "myname",
 *         ContactName = "John Smith",
 *         Email = "johnsmith@example.com",
 *         Location = "useast",
 *         PhoneNumber = "+1-555-1234",
 *         ResourceGroupName = "testrg",
 *         Role = "Network Manager",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/voiceservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := voiceservices.NewContact(ctx, "contact", &voiceservices.ContactArgs{
 * 			CommunicationsGatewayName: pulumi.String("myname"),
 * 			ContactName:               pulumi.String("John Smith"),
 * 			Email:                     pulumi.String("johnsmith@example.com"),
 * 			Location:                  pulumi.String("useast"),
 * 			PhoneNumber:               pulumi.String("+1-555-1234"),
 * 			ResourceGroupName:         pulumi.String("testrg"),
 * 			Role:                      pulumi.String("Network Manager"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.voiceservices.Contact;
 * import com.pulumi.azurenative.voiceservices.ContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contact = new Contact("contact", ContactArgs.builder()
 *             .communicationsGatewayName("myname")
 *             .contactName("John Smith")
 *             .email("johnsmith@example.com")
 *             .location("useast")
 *             .phoneNumber("+1-555-1234")
 *             .resourceGroupName("testrg")
 *             .role("Network Manager")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:voiceservices:Contact name2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.VoiceServices/communicationsGateways/{communicationsGatewayName}/contacts/{contactName}
 * ```
 * @property communicationsGatewayName Unique identifier for this deployment
 * @property contactName Full name of contact
 * @property email Email address of contact
 * @property location The geo-location where the resource lives
 * @property phoneNumber Telephone number of contact
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property role Job title of contact
 * @property tags Resource tags.
 */
public data class ContactArgs(
    public val communicationsGatewayName: Output<String>? = null,
    public val contactName: Output<String>? = null,
    public val email: Output<String>? = null,
    public val location: Output<String>? = null,
    public val phoneNumber: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val role: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.ContactArgs> {
    override fun toJava(): com.pulumi.azurenative.voiceservices.ContactArgs =
        com.pulumi.azurenative.voiceservices.ContactArgs.builder()
            .communicationsGatewayName(communicationsGatewayName?.applyValue({ args0 -> args0 }))
            .contactName(contactName?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ContactArgs].
 */
@PulumiTagMarker
public class ContactArgsBuilder internal constructor() {
    private var communicationsGatewayName: Output<String>? = null

    private var contactName: Output<String>? = null

    private var email: Output<String>? = null

    private var location: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var role: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Unique identifier for this deployment
     */
    @JvmName("tevshxwsjvjiipjv")
    public suspend fun communicationsGatewayName(`value`: Output<String>) {
        this.communicationsGatewayName = value
    }

    /**
     * @param value Full name of contact
     */
    @JvmName("mraeuuovwqdbodyt")
    public suspend fun contactName(`value`: Output<String>) {
        this.contactName = value
    }

    /**
     * @param value Email address of contact
     */
    @JvmName("kumefifjqlltycbe")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mxmnelueqnwrdtbr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Telephone number of contact
     */
    @JvmName("tyhijxrgqcbkpcji")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mrqqruiuqicelmba")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Job title of contact
     */
    @JvmName("wqcajckjleybcfks")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nrebxbklkycgxkgi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unique identifier for this deployment
     */
    @JvmName("jcmsmoleefiodvvh")
    public suspend fun communicationsGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communicationsGatewayName = mapped
    }

    /**
     * @param value Full name of contact
     */
    @JvmName("lslrijnwchdyvdhr")
    public suspend fun contactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactName = mapped
    }

    /**
     * @param value Email address of contact
     */
    @JvmName("jmslkyedfxjknqlt")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ubraryiyxqgvowvu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Telephone number of contact
     */
    @JvmName("fwtqxqnbigfgwfoi")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("srbcsqjuasoamrsd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Job title of contact
     */
    @JvmName("jovebctopwqmokmb")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vbiprwbmvvwoktpt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("emiuvqnecqibuvmi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ContactArgs = ContactArgs(
        communicationsGatewayName = communicationsGatewayName,
        contactName = contactName,
        email = email,
        location = location,
        phoneNumber = phoneNumber,
        resourceGroupName = resourceGroupName,
        role = role,
        tags = tags,
    )
}
