@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.voiceservices.kotlin.inputs

import com.pulumi.azurenative.voiceservices.inputs.ServiceRegionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The service region configuration needed for Teams Callings.
 * @property name The name of the region in which the resources needed for Teams Calling will be deployed.
 * @property primaryRegionProperties The configuration used in this region as primary, and other regions as backup.
 */
public data class ServiceRegionPropertiesArgs(
    public val name: Output<String>,
    public val primaryRegionProperties: Output<PrimaryRegionPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.voiceservices.inputs.ServiceRegionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.voiceservices.inputs.ServiceRegionPropertiesArgs =
        com.pulumi.azurenative.voiceservices.inputs.ServiceRegionPropertiesArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .primaryRegionProperties(
                primaryRegionProperties.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceRegionPropertiesArgs].
 */
@PulumiTagMarker
public class ServiceRegionPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var primaryRegionProperties: Output<PrimaryRegionPropertiesArgs>? = null

    /**
     * @param value The name of the region in which the resources needed for Teams Calling will be deployed.
     */
    @JvmName("onagskucbnfspecj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The configuration used in this region as primary, and other regions as backup.
     */
    @JvmName("yxueywrrqhmpwvlh")
    public suspend fun primaryRegionProperties(`value`: Output<PrimaryRegionPropertiesArgs>) {
        this.primaryRegionProperties = value
    }

    /**
     * @param value The name of the region in which the resources needed for Teams Calling will be deployed.
     */
    @JvmName("trbmrfqdrqlirrfd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The configuration used in this region as primary, and other regions as backup.
     */
    @JvmName("ionikqgnxtgbrpmd")
    public suspend fun primaryRegionProperties(`value`: PrimaryRegionPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryRegionProperties = mapped
    }

    /**
     * @param argument The configuration used in this region as primary, and other regions as backup.
     */
    @JvmName("sqwungwocmybhkun")
    public suspend
    fun primaryRegionProperties(argument: suspend PrimaryRegionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PrimaryRegionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.primaryRegionProperties = mapped
    }

    internal fun build(): ServiceRegionPropertiesArgs = ServiceRegionPropertiesArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        primaryRegionProperties = primaryRegionProperties ?: throw
            PulumiNullFieldException("primaryRegionProperties"),
    )
}
