@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.ConnectionGatewayArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.ConnectionGatewayDefinitionPropertiesArgs
import com.pulumi.azurenative.web.kotlin.inputs.ConnectionGatewayDefinitionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The gateway definition
 * Azure REST API version: 2016-06-01. Prior API version in Azure Native 1.x: 2016-06-01.
 * ## Example Usage
 * ### Replace a connection gateway definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionGateway = new AzureNative.Web.ConnectionGateway("connectionGateway", new()
 *     {
 *         ConnectionGatewayName = "test123",
 *         Properties = new AzureNative.Web.Inputs.ConnectionGatewayDefinitionPropertiesArgs
 *         {
 *             BackendUri = "https://WABI-WEST-US-redirect.analysis.windows.net",
 *             ConnectionGatewayInstallation = new AzureNative.Web.Inputs.ConnectionGatewayReferenceArgs
 *             {
 *                 Id = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/westus/connectionGatewayInstallations/865dccd1-5d5c-45fe-b5a0-249d4de4134c",
 *             },
 *             ContactInformation = new[]
 *             {
 *                 "test123@microsoft.com",
 *             },
 *             DisplayName = "test123",
 *             MachineName = "TEST123",
 *             Status = "Installed",
 *         },
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewConnectionGateway(ctx, "connectionGateway", &web.ConnectionGatewayArgs{
 * 			ConnectionGatewayName: pulumi.String("test123"),
 * 			Properties: web.ConnectionGatewayDefinitionResponseProperties{
 * 				BackendUri: pulumi.String("https://WABI-WEST-US-redirect.analysis.windows.net"),
 * 				ConnectionGatewayInstallation: &web.ConnectionGatewayReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/westus/connectionGatewayInstallations/865dccd1-5d5c-45fe-b5a0-249d4de4134c"),
 * 				},
 * 				ContactInformation: pulumi.StringArray{
 * 					pulumi.String("test123@microsoft.com"),
 * 				},
 * 				DisplayName: pulumi.String("test123"),
 * 				MachineName: pulumi.String("TEST123"),
 * 				Status:      pulumi.Any("Installed"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.ConnectionGateway;
 * import com.pulumi.azurenative.web.ConnectionGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionGateway = new ConnectionGateway("connectionGateway", ConnectionGatewayArgs.builder()
 *             .connectionGatewayName("test123")
 *             .properties(Map.ofEntries(
 *                 Map.entry("backendUri", "https://WABI-WEST-US-redirect.analysis.windows.net"),
 *                 Map.entry("connectionGatewayInstallation", Map.of("id", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/westus/connectionGatewayInstallations/865dccd1-5d5c-45fe-b5a0-249d4de4134c")),
 *                 Map.entry("contactInformation", "test123@microsoft.com"),
 *                 Map.entry("displayName", "test123"),
 *                 Map.entry("machineName", "TEST123"),
 *                 Map.entry("status", "Installed")
 *             ))
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:ConnectionGateway test123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/connectionGateways/{connectionGatewayName}
 * ```
 * @property connectionGatewayName The connection gateway name
 * @property location Resource location
 * @property properties
 * @property resourceGroupName The resource group
 * @property subscriptionId Subscription Id
 * @property tags Resource tags
 */
public data class ConnectionGatewayArgs(
    public val connectionGatewayName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ConnectionGatewayDefinitionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.ConnectionGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.web.ConnectionGatewayArgs =
        com.pulumi.azurenative.web.ConnectionGatewayArgs.builder()
            .connectionGatewayName(connectionGatewayName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionGatewayArgs].
 */
@PulumiTagMarker
public class ConnectionGatewayArgsBuilder internal constructor() {
    private var connectionGatewayName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ConnectionGatewayDefinitionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The connection gateway name
     */
    @JvmName("kkdqjxkrhoseyqoj")
    public suspend fun connectionGatewayName(`value`: Output<String>) {
        this.connectionGatewayName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("ppopeilsiwjdvluo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value
     */
    @JvmName("qybomrbakxkfbjkh")
    public suspend fun properties(`value`: Output<ConnectionGatewayDefinitionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group
     */
    @JvmName("tfshqbjfeepjppqj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("fhgdrhqspvrihjef")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("oskhtaqliudrhnkg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The connection gateway name
     */
    @JvmName("xjyalsnmngcavsep")
    public suspend fun connectionGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionGatewayName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("bkwoygpgoqcbykrs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value
     */
    @JvmName("xfgwamnvutecferk")
    public suspend fun properties(`value`: ConnectionGatewayDefinitionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("stvmbcvptkujcwpt")
    public suspend
    fun properties(argument: suspend ConnectionGatewayDefinitionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionGatewayDefinitionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group
     */
    @JvmName("lfbkehdbdnsbosch")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("uusukivbgsmxsmem")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("nxqewwlhcikklqfe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("morinmvcxbirsmtt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionGatewayArgs = ConnectionGatewayArgs(
        connectionGatewayName = connectionGatewayName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        subscriptionId = subscriptionId,
        tags = tags,
    )
}
