@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.StaticSiteCustomDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Static Site Custom Domain Overview ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Create or update a custom domain for a static site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteCustomDomain = new AzureNative.Web.StaticSiteCustomDomain("staticSiteCustomDomain", new()
 *     {
 *         DomainName = "custom.domain.net",
 *         Name = "testStaticSite0",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteCustomDomain(ctx, "staticSiteCustomDomain", &web.StaticSiteCustomDomainArgs{
 * 			DomainName:        pulumi.String("custom.domain.net"),
 * 			Name:              pulumi.String("testStaticSite0"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteCustomDomain;
 * import com.pulumi.azurenative.web.StaticSiteCustomDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteCustomDomain = new StaticSiteCustomDomain("staticSiteCustomDomain", StaticSiteCustomDomainArgs.builder()
 *             .domainName("custom.domain.net")
 *             .name("testStaticSite0")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteCustomDomain myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}
 * ```
 * @property domainName The custom domain to create.
 * @property kind Kind of resource.
 * @property name Name of the static site.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property validationMethod Validation method for adding a custom domain
 */
public data class StaticSiteCustomDomainArgs(
    public val domainName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val validationMethod: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.StaticSiteCustomDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.StaticSiteCustomDomainArgs =
        com.pulumi.azurenative.web.StaticSiteCustomDomainArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .validationMethod(validationMethod?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticSiteCustomDomainArgs].
 */
@PulumiTagMarker
public class StaticSiteCustomDomainArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var validationMethod: Output<String>? = null

    /**
     * @param value The custom domain to create.
     */
    @JvmName("kuwkedvqrautdsst")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("hiqkopkqitqtqqvq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the static site.
     */
    @JvmName("nmnquodeuaygdyth")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("aelfymymgpqkndmo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Validation method for adding a custom domain
     */
    @JvmName("gbpxegwlvreljdbo")
    public suspend fun validationMethod(`value`: Output<String>) {
        this.validationMethod = value
    }

    /**
     * @param value The custom domain to create.
     */
    @JvmName("llwaghborhtvmflv")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("knanyyrnyatukulq")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the static site.
     */
    @JvmName("pkmwhtwerihprsqq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("wcefquwdneuwcidt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Validation method for adding a custom domain
     */
    @JvmName("apututcawjowtoyv")
    public suspend fun validationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationMethod = mapped
    }

    internal fun build(): StaticSiteCustomDomainArgs = StaticSiteCustomDomainArgs(
        domainName = domainName,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        validationMethod = validationMethod,
    )
}
