@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuildArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Static Site Linked Backend ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Link a backend to a static site build
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteLinkedBackendForBuild = new AzureNative.Web.StaticSiteLinkedBackendForBuild("staticSiteLinkedBackendForBuild", new()
 *     {
 *         BackendResourceId = "/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/backendRg/providers/Microsoft.Web/sites/testBackend",
 *         EnvironmentName = "default",
 *         LinkedBackendName = "testBackend",
 *         Name = "testStaticSite0",
 *         Region = "West US 2",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteLinkedBackendForBuild(ctx, "staticSiteLinkedBackendForBuild", &web.StaticSiteLinkedBackendForBuildArgs{
 * 			BackendResourceId: pulumi.String("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/backendRg/providers/Microsoft.Web/sites/testBackend"),
 * 			EnvironmentName:   pulumi.String("default"),
 * 			LinkedBackendName: pulumi.String("testBackend"),
 * 			Name:              pulumi.String("testStaticSite0"),
 * 			Region:            pulumi.String("West US 2"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuild;
 * import com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuildArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteLinkedBackendForBuild = new StaticSiteLinkedBackendForBuild("staticSiteLinkedBackendForBuild", StaticSiteLinkedBackendForBuildArgs.builder()
 *             .backendResourceId("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/backendRg/providers/Microsoft.Web/sites/testBackend")
 *             .environmentName("default")
 *             .linkedBackendName("testBackend")
 *             .name("testStaticSite0")
 *             .region("West US 2")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteLinkedBackendForBuild testBackend /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/linkedBackends/{linkedBackendName}
 * ```
 * @property backendResourceId The resource id of the backend linked to the static site
 * @property environmentName The stage site identifier
 * @property kind Kind of resource.
 * @property linkedBackendName Name of the backend to link to the static site
 * @property name Name of the static site
 * @property region The region of the backend linked to the static site
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class StaticSiteLinkedBackendForBuildArgs(
    public val backendResourceId: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val linkedBackendName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val region: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuildArgs> {
    override fun toJava(): com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuildArgs =
        com.pulumi.azurenative.web.StaticSiteLinkedBackendForBuildArgs.builder()
            .backendResourceId(backendResourceId?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .linkedBackendName(linkedBackendName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticSiteLinkedBackendForBuildArgs].
 */
@PulumiTagMarker
public class StaticSiteLinkedBackendForBuildArgsBuilder internal constructor() {
    private var backendResourceId: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var kind: Output<String>? = null

    private var linkedBackendName: Output<String>? = null

    private var name: Output<String>? = null

    private var region: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The resource id of the backend linked to the static site
     */
    @JvmName("cawdlbgjoqdrutqp")
    public suspend fun backendResourceId(`value`: Output<String>) {
        this.backendResourceId = value
    }

    /**
     * @param value The stage site identifier
     */
    @JvmName("kdvrkitmnhpdfcoy")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("xihqvpvbreumwide")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the backend to link to the static site
     */
    @JvmName("esfntuxyxiawappd")
    public suspend fun linkedBackendName(`value`: Output<String>) {
        this.linkedBackendName = value
    }

    /**
     * @param value Name of the static site
     */
    @JvmName("lmdhnymmldbliewt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The region of the backend linked to the static site
     */
    @JvmName("qbmepycygirlwehl")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("wxsenhsshenjqomi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource id of the backend linked to the static site
     */
    @JvmName("fjsmtmhgriubdodr")
    public suspend fun backendResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendResourceId = mapped
    }

    /**
     * @param value The stage site identifier
     */
    @JvmName("jlcmdhayabicjnyv")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("wyeynxlxqupuvdho")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the backend to link to the static site
     */
    @JvmName("aqgvemfkmarxnked")
    public suspend fun linkedBackendName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedBackendName = mapped
    }

    /**
     * @param value Name of the static site
     */
    @JvmName("mymehspuedmkxwhp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The region of the backend linked to the static site
     */
    @JvmName("dgvpdhgvjvasiprf")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("idwejfmfmrtrtiev")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): StaticSiteLinkedBackendForBuildArgs = StaticSiteLinkedBackendForBuildArgs(
        backendResourceId = backendResourceId,
        environmentName = environmentName,
        kind = kind,
        linkedBackendName = linkedBackendName,
        name = name,
        region = region,
        resourceGroupName = resourceGroupName,
    )
}
