@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Static Site User Provided Function App ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Register a user provided function app with a static site build
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteUserProvidedFunctionAppForStaticSiteBuild = new AzureNative.Web.StaticSiteUserProvidedFunctionAppForStaticSiteBuild("staticSiteUserProvidedFunctionAppForStaticSiteBuild", new()
 *     {
 *         EnvironmentName = "default",
 *         FunctionAppName = "testFunctionApp",
 *         FunctionAppRegion = "West US 2",
 *         FunctionAppResourceId = "/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/functionRG/providers/Microsoft.Web/sites/testFunctionApp",
 *         IsForced = true,
 *         Name = "testStaticSite0",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteUserProvidedFunctionAppForStaticSiteBuild(ctx, "staticSiteUserProvidedFunctionAppForStaticSiteBuild", &web.StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs{
 * 			EnvironmentName:       pulumi.String("default"),
 * 			FunctionAppName:       pulumi.String("testFunctionApp"),
 * 			FunctionAppRegion:     pulumi.String("West US 2"),
 * 			FunctionAppResourceId: pulumi.String("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/functionRG/providers/Microsoft.Web/sites/testFunctionApp"),
 * 			IsForced:              pulumi.Bool(true),
 * 			Name:                  pulumi.String("testStaticSite0"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSiteBuild;
 * import com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteUserProvidedFunctionAppForStaticSiteBuild = new StaticSiteUserProvidedFunctionAppForStaticSiteBuild("staticSiteUserProvidedFunctionAppForStaticSiteBuild", StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs.builder()
 *             .environmentName("default")
 *             .functionAppName("testFunctionApp")
 *             .functionAppRegion("West US 2")
 *             .functionAppResourceId("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/functionRG/providers/Microsoft.Web/sites/testFunctionApp")
 *             .isForced(true)
 *             .name("testStaticSite0")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteUserProvidedFunctionAppForStaticSiteBuild testFunctionApp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}
 * ```
 * @property environmentName The stage site identifier.
 * @property functionAppName Name of the function app to register with the static site build.
 * @property functionAppRegion The region of the function app registered with the static site
 * @property functionAppResourceId The resource id of the function app registered with the static site
 * @property isForced Specify <code>true</code> to force the update of the auth configuration on the function app even if an AzureStaticWebApps provider is already configured on the function app. The default is <code>false</code>.
 * @property kind Kind of resource.
 * @property name Name of the static site.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs(
    public val environmentName: Output<String>? = null,
    public val functionAppName: Output<String>? = null,
    public val functionAppRegion: Output<String>? = null,
    public val functionAppResourceId: Output<String>? = null,
    public val isForced: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs =
        com.pulumi.azurenative.web.StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs.builder()
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .functionAppName(functionAppName?.applyValue({ args0 -> args0 }))
            .functionAppRegion(functionAppRegion?.applyValue({ args0 -> args0 }))
            .functionAppResourceId(functionAppResourceId?.applyValue({ args0 -> args0 }))
            .isForced(isForced?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs].
 */
@PulumiTagMarker
public class StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgsBuilder internal constructor() {
    private var environmentName: Output<String>? = null

    private var functionAppName: Output<String>? = null

    private var functionAppRegion: Output<String>? = null

    private var functionAppResourceId: Output<String>? = null

    private var isForced: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The stage site identifier.
     */
    @JvmName("jqbgfbfmnthrlvay")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Name of the function app to register with the static site build.
     */
    @JvmName("ugbbtebxxpcbiqmc")
    public suspend fun functionAppName(`value`: Output<String>) {
        this.functionAppName = value
    }

    /**
     * @param value The region of the function app registered with the static site
     */
    @JvmName("gpsjvwgyatxqxftx")
    public suspend fun functionAppRegion(`value`: Output<String>) {
        this.functionAppRegion = value
    }

    /**
     * @param value The resource id of the function app registered with the static site
     */
    @JvmName("yipamorehbxbircy")
    public suspend fun functionAppResourceId(`value`: Output<String>) {
        this.functionAppResourceId = value
    }

    /**
     * @param value Specify <code>true</code> to force the update of the auth configuration on the function app even if an AzureStaticWebApps provider is already configured on the function app. The default is <code>false</code>.
     */
    @JvmName("wmujabssslwvpicn")
    public suspend fun isForced(`value`: Output<Boolean>) {
        this.isForced = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("lajfwmnvruwbiwar")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the static site.
     */
    @JvmName("rwkwyaddkcfsnxlf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("uoqfdlutisgpyfjd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The stage site identifier.
     */
    @JvmName("wqjweajoohpfooap")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the function app to register with the static site build.
     */
    @JvmName("qdsvhpevwifrojin")
    public suspend fun functionAppName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAppName = mapped
    }

    /**
     * @param value The region of the function app registered with the static site
     */
    @JvmName("vsmjucyfonkiepqk")
    public suspend fun functionAppRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAppRegion = mapped
    }

    /**
     * @param value The resource id of the function app registered with the static site
     */
    @JvmName("vemeyfbbroxobebw")
    public suspend fun functionAppResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAppResourceId = mapped
    }

    /**
     * @param value Specify <code>true</code> to force the update of the auth configuration on the function app even if an AzureStaticWebApps provider is already configured on the function app. The default is <code>false</code>.
     */
    @JvmName("nsmvlgemaqfaiqcv")
    public suspend fun isForced(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isForced = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("vxxabhqlsmxfavfg")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the static site.
     */
    @JvmName("obkvdfxxgufsuxnu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("odmpxhxjoqirtyaq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs =
        StaticSiteUserProvidedFunctionAppForStaticSiteBuildArgs(
            environmentName = environmentName,
            functionAppName = functionAppName,
            functionAppRegion = functionAppRegion,
            functionAppResourceId = functionAppResourceId,
            isForced = isForced,
            kind = kind,
            name = name,
            resourceGroupName = resourceGroupName,
        )
}
