@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WebAppApplicationSettingsSlot].
 */
@PulumiTagMarker
public class WebAppApplicationSettingsSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppApplicationSettingsSlotArgs = WebAppApplicationSettingsSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppApplicationSettingsSlotArgsBuilder.() -> Unit) {
        val builder = WebAppApplicationSettingsSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppApplicationSettingsSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppApplicationSettingsSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppApplicationSettingsSlot(builtJavaResource)
    }
}

/**
 * String dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppApplicationSettingsSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings
 * ```
 */
public class WebAppApplicationSettingsSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppApplicationSettingsSlot,
) : KotlinCustomResource(javaResource, WebAppApplicationSettingsSlotMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Settings.
     */
    public val properties: Output<Map<String, String>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppApplicationSettingsSlotMapper : ResourceMapper<WebAppApplicationSettingsSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppApplicationSettingsSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppApplicationSettingsSlot =
        WebAppApplicationSettingsSlot(
            javaResource as
                com.pulumi.azurenative.web.WebAppApplicationSettingsSlot,
        )
}

/**
 * @see [WebAppApplicationSettingsSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppApplicationSettingsSlot].
 */
public suspend fun webAppApplicationSettingsSlot(
    name: String,
    block: suspend WebAppApplicationSettingsSlotResourceBuilder.() -> Unit,
):
    WebAppApplicationSettingsSlot {
    val builder = WebAppApplicationSettingsSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppApplicationSettingsSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppApplicationSettingsSlot(name: String): WebAppApplicationSettingsSlot {
    val builder = WebAppApplicationSettingsSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
