@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppConnectionStringsSlotArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.ConnStringValueTypePairArgs
import com.pulumi.azurenative.web.kotlin.inputs.ConnStringValueTypePairArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * String dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppConnectionStringsSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings
 * ```
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property properties Connection strings.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will update the connection settings for the production slot.
 */
public data class WebAppConnectionStringsSlotArgs(
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<Map<String, ConnStringValueTypePairArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppConnectionStringsSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppConnectionStringsSlotArgs =
        com.pulumi.azurenative.web.WebAppConnectionStringsSlotArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppConnectionStringsSlotArgs].
 */
@PulumiTagMarker
public class WebAppConnectionStringsSlotArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<Map<String, ConnStringValueTypePairArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("snuouddqtaryohmo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("dugnxdosemaqkpvs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Connection strings.
     */
    @JvmName("jygincwcyjhhiwly")
    public suspend fun properties(`value`: Output<Map<String, ConnStringValueTypePairArgs>>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bkbdgnkwomhptfsl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the connection settings for the production slot.
     */
    @JvmName("xgpkwfmgjevheffy")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("suhvbdenannaseef")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("jywgckjdyhdneytc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Connection strings.
     */
    @JvmName("witrtksfeydeoqaa")
    public suspend fun properties(`value`: Map<String, ConnStringValueTypePairArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Connection strings.
     */
    @JvmName("nbbtfiisuybxhlqd")
    public suspend fun properties(
        vararg
        argument: Pair<String, suspend ConnStringValueTypePairArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ConnStringValueTypePairArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param values Connection strings.
     */
    @JvmName("yphllflqwpfrjdtw")
    public fun properties(vararg values: Pair<String, ConnStringValueTypePairArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("lljxniukxolelfnd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the connection settings for the production slot.
     */
    @JvmName("xwblmaryltoblvwn")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    internal fun build(): WebAppConnectionStringsSlotArgs = WebAppConnectionStringsSlotArgs(
        kind = kind,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        slot = slot,
    )
}
