@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppFtpAllowedArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Publishing Credentials Policies parameters.
 * Azure REST API version: 2022-09-01.
 * Other available API versions: 2019-08-01, 2020-06-01, 2020-09-01, 2020-10-01, 2020-12-01, 2021-01-01, 2021-01-15, 2021-02-01, 2021-03-01, 2022-03-01, 2023-01-01.
 * ## Example Usage
 * ### Update FTP Allowed
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppFtpAllowed = new AzureNative.Web.WebAppFtpAllowed("webAppFtpAllowed", new()
 *     {
 *         Allow = true,
 *         Name = "testSite",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppFtpAllowed(ctx, "webAppFtpAllowed", &web.WebAppFtpAllowedArgs{
 * 			Allow:             pulumi.Bool(true),
 * 			Name:              pulumi.String("testSite"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppFtpAllowed;
 * import com.pulumi.azurenative.web.WebAppFtpAllowedArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppFtpAllowed = new WebAppFtpAllowed("webAppFtpAllowed", WebAppFtpAllowedArgs.builder()
 *             .allow(true)
 *             .name("testSite")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppFtpAllowed myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/ftp
 * ```
 * @property allow <code>true</code> to allow access to a publishing method; otherwise, <code>false</code>.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class WebAppFtpAllowedArgs(
    public val allow: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppFtpAllowedArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppFtpAllowedArgs =
        com.pulumi.azurenative.web.WebAppFtpAllowedArgs.builder()
            .allow(allow?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppFtpAllowedArgs].
 */
@PulumiTagMarker
public class WebAppFtpAllowedArgsBuilder internal constructor() {
    private var allow: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value <code>true</code> to allow access to a publishing method; otherwise, <code>false</code>.
     */
    @JvmName("mywynmvfsdbviqks")
    public suspend fun allow(`value`: Output<Boolean>) {
        this.allow = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("mlqolyaxjgusivmv")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("boltomvqmdlqnnvp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ilmvfpratbwkvang")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value <code>true</code> to allow access to a publishing method; otherwise, <code>false</code>.
     */
    @JvmName("cmlfbpchcykwvlha")
    public suspend fun allow(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("gpqynqgdefohfsno")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("hcfmxakccyawyndr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("keybgeelvathhwbf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WebAppFtpAllowedArgs = WebAppFtpAllowedArgs(
        allow = allow,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
    )
}
