@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppHostNameBindingArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.AzureResourceType
import com.pulumi.azurenative.web.kotlin.enums.CustomHostNameDnsRecordType
import com.pulumi.azurenative.web.kotlin.enums.HostNameType
import com.pulumi.azurenative.web.kotlin.enums.SslState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A hostname binding object.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppHostNameBinding myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}
 * ```
 * @property azureResourceName Azure resource name.
 * @property azureResourceType Azure resource type.
 * @property customHostNameDnsRecordType Custom DNS record type.
 * @property domainId Fully qualified ARM domain resource URI.
 * @property hostName Hostname in the hostname binding.
 * @property hostNameType Hostname type.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property siteName App Service app name.
 * @property sslState SSL type
 * @property thumbprint SSL certificate thumbprint
 */
public data class WebAppHostNameBindingArgs(
    public val azureResourceName: Output<String>? = null,
    public val azureResourceType: Output<AzureResourceType>? = null,
    public val customHostNameDnsRecordType: Output<CustomHostNameDnsRecordType>? = null,
    public val domainId: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val hostNameType: Output<HostNameType>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val sslState: Output<SslState>? = null,
    public val thumbprint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppHostNameBindingArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppHostNameBindingArgs =
        com.pulumi.azurenative.web.WebAppHostNameBindingArgs.builder()
            .azureResourceName(azureResourceName?.applyValue({ args0 -> args0 }))
            .azureResourceType(azureResourceType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customHostNameDnsRecordType(
                customHostNameDnsRecordType?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .domainId(domainId?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .hostNameType(hostNameType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .sslState(sslState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppHostNameBindingArgs].
 */
@PulumiTagMarker
public class WebAppHostNameBindingArgsBuilder internal constructor() {
    private var azureResourceName: Output<String>? = null

    private var azureResourceType: Output<AzureResourceType>? = null

    private var customHostNameDnsRecordType: Output<CustomHostNameDnsRecordType>? = null

    private var domainId: Output<String>? = null

    private var hostName: Output<String>? = null

    private var hostNameType: Output<HostNameType>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var sslState: Output<SslState>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value Azure resource name.
     */
    @JvmName("vmgvtxdjvmiseljh")
    public suspend fun azureResourceName(`value`: Output<String>) {
        this.azureResourceName = value
    }

    /**
     * @param value Azure resource type.
     */
    @JvmName("jayreffdhsblxqgx")
    public suspend fun azureResourceType(`value`: Output<AzureResourceType>) {
        this.azureResourceType = value
    }

    /**
     * @param value Custom DNS record type.
     */
    @JvmName("njbrwoyswmitckmu")
    public suspend fun customHostNameDnsRecordType(`value`: Output<CustomHostNameDnsRecordType>) {
        this.customHostNameDnsRecordType = value
    }

    /**
     * @param value Fully qualified ARM domain resource URI.
     */
    @JvmName("okpwgttpqraewjvn")
    public suspend fun domainId(`value`: Output<String>) {
        this.domainId = value
    }

    /**
     * @param value Hostname in the hostname binding.
     */
    @JvmName("iohndteqbgsrwoar")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Hostname type.
     */
    @JvmName("cmyxaisbtbogjwfb")
    public suspend fun hostNameType(`value`: Output<HostNameType>) {
        this.hostNameType = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("xhucyboxypkckwqg")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("hvtvdtutkjfaodck")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("egugvwbrefuuuvyn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value App Service app name.
     */
    @JvmName("sphbnunuxbsnjajm")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value SSL type
     */
    @JvmName("ccnevsfjirlifalp")
    public suspend fun sslState(`value`: Output<SslState>) {
        this.sslState = value
    }

    /**
     * @param value SSL certificate thumbprint
     */
    @JvmName("mijvypewmpwkoayv")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value Azure resource name.
     */
    @JvmName("ykbewrudsacbilus")
    public suspend fun azureResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureResourceName = mapped
    }

    /**
     * @param value Azure resource type.
     */
    @JvmName("gmamavsjjfdolhgq")
    public suspend fun azureResourceType(`value`: AzureResourceType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureResourceType = mapped
    }

    /**
     * @param value Custom DNS record type.
     */
    @JvmName("hrufnfyoprrncsdj")
    public suspend fun customHostNameDnsRecordType(`value`: CustomHostNameDnsRecordType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHostNameDnsRecordType = mapped
    }

    /**
     * @param value Fully qualified ARM domain resource URI.
     */
    @JvmName("vfrvjxttagdkgsux")
    public suspend fun domainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainId = mapped
    }

    /**
     * @param value Hostname in the hostname binding.
     */
    @JvmName("tontftaaldturdvc")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Hostname type.
     */
    @JvmName("yelxldmkmelupqxw")
    public suspend fun hostNameType(`value`: HostNameType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNameType = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("xitoskihwqambhid")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("nofijtlorgiipgpt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("eloomgyiqofufjnn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value App Service app name.
     */
    @JvmName("icdrbmurhflpvgwo")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value SSL type
     */
    @JvmName("oyoecashehqaygkn")
    public suspend fun sslState(`value`: SslState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslState = mapped
    }

    /**
     * @param value SSL certificate thumbprint
     */
    @JvmName("yvwwknahslfruucu")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): WebAppHostNameBindingArgs = WebAppHostNameBindingArgs(
        azureResourceName = azureResourceName,
        azureResourceType = azureResourceType,
        customHostNameDnsRecordType = customHostNameDnsRecordType,
        domainId = domainId,
        hostName = hostName,
        hostNameType = hostNameType,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
        sslState = sslState,
        thumbprint = thumbprint,
    )
}
