@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppPremierAddOnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Premier add-on.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppPremierAddOn myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}
 * ```
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property marketplaceOffer Premier add on Marketplace offer.
 * @property marketplacePublisher Premier add on Marketplace publisher.
 * @property name Name of the app.
 * @property premierAddOnName Add-on name.
 * @property product Premier add on Product.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property sku Premier add on SKU.
 * @property tags Resource tags.
 * @property vendor Premier add on Vendor.
 */
public data class WebAppPremierAddOnArgs(
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val marketplaceOffer: Output<String>? = null,
    public val marketplacePublisher: Output<String>? = null,
    public val name: Output<String>? = null,
    public val premierAddOnName: Output<String>? = null,
    public val product: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vendor: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppPremierAddOnArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppPremierAddOnArgs =
        com.pulumi.azurenative.web.WebAppPremierAddOnArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .marketplaceOffer(marketplaceOffer?.applyValue({ args0 -> args0 }))
            .marketplacePublisher(marketplacePublisher?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .premierAddOnName(premierAddOnName?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vendor(vendor?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppPremierAddOnArgs].
 */
@PulumiTagMarker
public class WebAppPremierAddOnArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var marketplaceOffer: Output<String>? = null

    private var marketplacePublisher: Output<String>? = null

    private var name: Output<String>? = null

    private var premierAddOnName: Output<String>? = null

    private var product: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vendor: Output<String>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("uxrrrsblkcdledub")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("hdccnspdvxocemoe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Premier add on Marketplace offer.
     */
    @JvmName("fieqkhmuqkktqjmu")
    public suspend fun marketplaceOffer(`value`: Output<String>) {
        this.marketplaceOffer = value
    }

    /**
     * @param value Premier add on Marketplace publisher.
     */
    @JvmName("jakwrdbrmndexbyp")
    public suspend fun marketplacePublisher(`value`: Output<String>) {
        this.marketplacePublisher = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("fncuebdabkpoqwnx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Add-on name.
     */
    @JvmName("hklmnreqsjkkbwme")
    public suspend fun premierAddOnName(`value`: Output<String>) {
        this.premierAddOnName = value
    }

    /**
     * @param value Premier add on Product.
     */
    @JvmName("wbnfcqvatonngulc")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("lkkwatglorxgglra")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Premier add on SKU.
     */
    @JvmName("jnmcbjgdtbubhqbn")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("icxuwsldrfclvvxw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Premier add on Vendor.
     */
    @JvmName("mufweduricmtqfyf")
    public suspend fun vendor(`value`: Output<String>) {
        this.vendor = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("elcrhkhxqmrgmhoj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("gtbyltmrwoebgdif")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Premier add on Marketplace offer.
     */
    @JvmName("paayjnwqbrjqkxyb")
    public suspend fun marketplaceOffer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceOffer = mapped
    }

    /**
     * @param value Premier add on Marketplace publisher.
     */
    @JvmName("asfhkfslxciyitwg")
    public suspend fun marketplacePublisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplacePublisher = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("ppbrdpdlxqqqdktq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Add-on name.
     */
    @JvmName("tuunirihgntccnbo")
    public suspend fun premierAddOnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.premierAddOnName = mapped
    }

    /**
     * @param value Premier add on Product.
     */
    @JvmName("elaewhsnntpqeaus")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("jicxuuwicrtxrjtc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Premier add on SKU.
     */
    @JvmName("fwsxfrgcewxwmgmt")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rlqxvhshddusdkac")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rpnnyurlrrxiubgc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Premier add on Vendor.
     */
    @JvmName("spbbuubtyxojcaoo")
    public suspend fun vendor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vendor = mapped
    }

    internal fun build(): WebAppPremierAddOnArgs = WebAppPremierAddOnArgs(
        kind = kind,
        location = location,
        marketplaceOffer = marketplaceOffer,
        marketplacePublisher = marketplacePublisher,
        name = name,
        premierAddOnName = premierAddOnName,
        product = product,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        vendor = vendor,
    )
}
