@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.PrivateLinkConnectionStateArgs
import com.pulumi.azurenative.web.kotlin.inputs.PrivateLinkConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Remote Private Endpoint Connection ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Approves or rejects a private endpoint connection for a site.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppPrivateEndpointConnection = new AzureNative.Web.WebAppPrivateEndpointConnection("webAppPrivateEndpointConnection", new()
 *     {
 *         Name = "testSite",
 *         PrivateEndpointConnectionName = "connection",
 *         PrivateLinkServiceConnectionState = new AzureNative.Web.Inputs.PrivateLinkConnectionStateArgs
 *         {
 *             ActionsRequired = "",
 *             Description = "Approved by admin.",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppPrivateEndpointConnection(ctx, "webAppPrivateEndpointConnection", &web.WebAppPrivateEndpointConnectionArgs{
 * 			Name:                          pulumi.String("testSite"),
 * 			PrivateEndpointConnectionName: pulumi.String("connection"),
 * 			PrivateLinkServiceConnectionState: &web.PrivateLinkConnectionStateArgs{
 * 				ActionsRequired: pulumi.String(""),
 * 				Description:     pulumi.String("Approved by admin."),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppPrivateEndpointConnection;
 * import com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppPrivateEndpointConnection = new WebAppPrivateEndpointConnection("webAppPrivateEndpointConnection", WebAppPrivateEndpointConnectionArgs.builder()
 *             .name("testSite")
 *             .privateEndpointConnectionName("connection")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", ""),
 *                 Map.entry("description", "Approved by admin."),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppPrivateEndpointConnection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property kind Kind of resource.
 * @property name Name of the site.
 * @property privateEndpointConnectionName
 * @property privateLinkServiceConnectionState The state of a private link connection
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class WebAppPrivateEndpointConnectionArgs(
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionArgs =
        com.pulumi.azurenative.web.WebAppPrivateEndpointConnectionArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppPrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class WebAppPrivateEndpointConnectionArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkConnectionStateArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("qmkwljcrnnsieqgg")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the site.
     */
    @JvmName("slmehebhusxpxphs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("kjattgoasyjcfiaw")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value The state of a private link connection
     */
    @JvmName("icbaeqsxtxxagqbo")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("vkmfoygeoacmqmmh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ehkiakfhhighoqcs")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the site.
     */
    @JvmName("dxdbaveqavkhpkyb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("rweoiroirgkrhqro")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The state of a private link connection
     */
    @JvmName("xqdvvioigcwaogbj")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument The state of a private link connection
     */
    @JvmName("anlqxnndxxmxyvyq")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("tcrwqatyxonowpog")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WebAppPrivateEndpointConnectionArgs = WebAppPrivateEndpointConnectionArgs(
        kind = kind,
        name = name,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
