@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppRelayServiceConnectionSlot].
 */
@PulumiTagMarker
public class WebAppRelayServiceConnectionSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppRelayServiceConnectionSlotArgs = WebAppRelayServiceConnectionSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppRelayServiceConnectionSlotArgsBuilder.() -> Unit) {
        val builder = WebAppRelayServiceConnectionSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppRelayServiceConnectionSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppRelayServiceConnectionSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppRelayServiceConnectionSlot(builtJavaResource)
    }
}

/**
 * Hybrid Connection for an App Service app.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppRelayServiceConnectionSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}
 * ```
 */
public class WebAppRelayServiceConnectionSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppRelayServiceConnectionSlot,
) : KotlinCustomResource(javaResource, WebAppRelayServiceConnectionSlotMapper) {
    public val biztalkUri: Output<String>?
        get() = javaResource.biztalkUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val entityConnectionString: Output<String>?
        get() = javaResource.entityConnectionString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val entityName: Output<String>?
        get() = javaResource.entityName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val hostname: Output<String>?
        get() = javaResource.hostname().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val resourceConnectionString: Output<String>?
        get() = javaResource.resourceConnectionString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val resourceType: Output<String>?
        get() = javaResource.resourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppRelayServiceConnectionSlotMapper :
    ResourceMapper<WebAppRelayServiceConnectionSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppRelayServiceConnectionSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppRelayServiceConnectionSlot =
        WebAppRelayServiceConnectionSlot(
            javaResource as
                com.pulumi.azurenative.web.WebAppRelayServiceConnectionSlot,
        )
}

/**
 * @see [WebAppRelayServiceConnectionSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppRelayServiceConnectionSlot].
 */
public suspend fun webAppRelayServiceConnectionSlot(
    name: String,
    block: suspend WebAppRelayServiceConnectionSlotResourceBuilder.() -> Unit,
):
    WebAppRelayServiceConnectionSlot {
    val builder = WebAppRelayServiceConnectionSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppRelayServiceConnectionSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppRelayServiceConnectionSlot(name: String): WebAppRelayServiceConnectionSlot {
    val builder = WebAppRelayServiceConnectionSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
