@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppRelayServiceConnectionSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Hybrid Connection for an App Service app.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppRelayServiceConnectionSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}
 * ```
 * @property biztalkUri
 * @property entityConnectionString
 * @property entityName
 * @property hostname
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property port
 * @property resourceConnectionString
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property resourceType
 * @property slot Name of the deployment slot. If a slot is not specified, the API will create or update a hybrid connection for the production slot.
 */
public data class WebAppRelayServiceConnectionSlotArgs(
    public val biztalkUri: Output<String>? = null,
    public val entityConnectionString: Output<String>? = null,
    public val entityName: Output<String>? = null,
    public val hostname: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val resourceConnectionString: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val slot: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppRelayServiceConnectionSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppRelayServiceConnectionSlotArgs =
        com.pulumi.azurenative.web.WebAppRelayServiceConnectionSlotArgs.builder()
            .biztalkUri(biztalkUri?.applyValue({ args0 -> args0 }))
            .entityConnectionString(entityConnectionString?.applyValue({ args0 -> args0 }))
            .entityName(entityName?.applyValue({ args0 -> args0 }))
            .hostname(hostname?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceConnectionString(resourceConnectionString?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppRelayServiceConnectionSlotArgs].
 */
@PulumiTagMarker
public class WebAppRelayServiceConnectionSlotArgsBuilder internal constructor() {
    private var biztalkUri: Output<String>? = null

    private var entityConnectionString: Output<String>? = null

    private var entityName: Output<String>? = null

    private var hostname: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var port: Output<Int>? = null

    private var resourceConnectionString: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var slot: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("xbxcavhrkgjwilkv")
    public suspend fun biztalkUri(`value`: Output<String>) {
        this.biztalkUri = value
    }

    /**
     * @param value
     */
    @JvmName("auksfojbojqlnpbm")
    public suspend fun entityConnectionString(`value`: Output<String>) {
        this.entityConnectionString = value
    }

    /**
     * @param value
     */
    @JvmName("hinksgjoktntipnk")
    public suspend fun entityName(`value`: Output<String>) {
        this.entityName = value
    }

    /**
     * @param value
     */
    @JvmName("bjqvftjrxqrgutcc")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ifbbfodlgxqpjusw")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("cqpauvmjojdvbati")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("feyuqmaiwfoembbg")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("cfinmxdvbybxewnv")
    public suspend fun resourceConnectionString(`value`: Output<String>) {
        this.resourceConnectionString = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("oegltkkhfvchtror")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("soxtkbrsgpwtiast")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will create or update a hybrid connection for the production slot.
     */
    @JvmName("nwlsmhvlolwdxeyu")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value
     */
    @JvmName("fvnydfawcrqtqsju")
    public suspend fun biztalkUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.biztalkUri = mapped
    }

    /**
     * @param value
     */
    @JvmName("litkpfqcpqgkwebs")
    public suspend fun entityConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityConnectionString = mapped
    }

    /**
     * @param value
     */
    @JvmName("apaecmtxakwqavrf")
    public suspend fun entityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityName = mapped
    }

    /**
     * @param value
     */
    @JvmName("lquwtxspmnsmpyqu")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("riwyfmnrciwptiyj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("esjtwfhwxqwqulkq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("xhjkshaccjkksnml")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("nveyyrbqbfgxyqsg")
    public suspend fun resourceConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceConnectionString = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ubwkiclmfwwpbngx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("hjamerxjfqvwyelf")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will create or update a hybrid connection for the production slot.
     */
    @JvmName("ggqklnohfnevxjbc")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    internal fun build(): WebAppRelayServiceConnectionSlotArgs = WebAppRelayServiceConnectionSlotArgs(
        biztalkUri = biztalkUri,
        entityConnectionString = entityConnectionString,
        entityName = entityName,
        hostname = hostname,
        kind = kind,
        name = name,
        port = port,
        resourceConnectionString = resourceConnectionString,
        resourceGroupName = resourceGroupName,
        resourceType = resourceType,
        slot = slot,
    )
}
