@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WebAppSiteExtensionSlot].
 */
@PulumiTagMarker
public class WebAppSiteExtensionSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppSiteExtensionSlotArgs = WebAppSiteExtensionSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppSiteExtensionSlotArgsBuilder.() -> Unit) {
        val builder = WebAppSiteExtensionSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppSiteExtensionSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppSiteExtensionSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppSiteExtensionSlot(builtJavaResource)
    }
}

/**
 * Site Extension Information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-08-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSiteExtensionSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}
 * ```
 */
public class WebAppSiteExtensionSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppSiteExtensionSlot,
) : KotlinCustomResource(javaResource, WebAppSiteExtensionSlotMapper) {
    /**
     * List of authors.
     */
    public val authors: Output<List<String>>?
        get() = javaResource.authors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Site Extension comment.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Detailed description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Count of downloads.
     */
    public val downloadCount: Output<Int>?
        get() = javaResource.downloadCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Site extension ID.
     */
    public val extensionId: Output<String>?
        get() = javaResource.extensionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Site extension type.
     */
    public val extensionType: Output<String>?
        get() = javaResource.extensionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Extension URL.
     */
    public val extensionUrl: Output<String>?
        get() = javaResource.extensionUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Feed URL.
     */
    public val feedUrl: Output<String>?
        get() = javaResource.feedUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Icon URL.
     */
    public val iconUrl: Output<String>?
        get() = javaResource.iconUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Installed timestamp.
     */
    public val installedDateTime: Output<String>?
        get() = javaResource.installedDateTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Installer command line parameters.
     */
    public val installerCommandLineParams: Output<String>?
        get() = javaResource.installerCommandLineParams().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * License URL.
     */
    public val licenseUrl: Output<String>?
        get() = javaResource.licenseUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * <code>true</code> if the local version is the latest version; <code>false</code> otherwise.
     */
    public val localIsLatestVersion: Output<Boolean>?
        get() = javaResource.localIsLatestVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Local path.
     */
    public val localPath: Output<String>?
        get() = javaResource.localPath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Project URL.
     */
    public val projectUrl: Output<String>?
        get() = javaResource.projectUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Published timestamp.
     */
    public val publishedDateTime: Output<String>?
        get() = javaResource.publishedDateTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Summary description.
     */
    public val summary: Output<String>?
        get() = javaResource.summary().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val title: Output<String>?
        get() = javaResource.title().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version information.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object WebAppSiteExtensionSlotMapper : ResourceMapper<WebAppSiteExtensionSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppSiteExtensionSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppSiteExtensionSlot =
        WebAppSiteExtensionSlot(javaResource as com.pulumi.azurenative.web.WebAppSiteExtensionSlot)
}

/**
 * @see [WebAppSiteExtensionSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppSiteExtensionSlot].
 */
public suspend fun webAppSiteExtensionSlot(
    name: String,
    block: suspend WebAppSiteExtensionSlotResourceBuilder.() -> Unit,
): WebAppSiteExtensionSlot {
    val builder = WebAppSiteExtensionSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppSiteExtensionSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppSiteExtensionSlot(name: String): WebAppSiteExtensionSlot {
    val builder = WebAppSiteExtensionSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
