@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSitePushSettingsSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Push settings for the App.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSitePushSettingsSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings
 * ```
 * @property dynamicTagsJson Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
 * @property isPushEnabled Gets or sets a flag indicating whether the Push endpoint is enabled.
 * @property kind Kind of resource.
 * @property name Name of web app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of web app slot. If not specified then will default to production slot.
 * @property tagWhitelistJson Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
 * @property tagsRequiringAuth Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
 * Tags can consist of alphanumeric characters and the following:
 * '_', '@', '#', '.', ':', '-'.
 * Validation should be performed at the PushRequestHandler.
 */
public data class WebAppSitePushSettingsSlotArgs(
    public val dynamicTagsJson: Output<String>? = null,
    public val isPushEnabled: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
    public val tagWhitelistJson: Output<String>? = null,
    public val tagsRequiringAuth: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSitePushSettingsSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSitePushSettingsSlotArgs =
        com.pulumi.azurenative.web.WebAppSitePushSettingsSlotArgs.builder()
            .dynamicTagsJson(dynamicTagsJson?.applyValue({ args0 -> args0 }))
            .isPushEnabled(isPushEnabled?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 }))
            .tagWhitelistJson(tagWhitelistJson?.applyValue({ args0 -> args0 }))
            .tagsRequiringAuth(tagsRequiringAuth?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSitePushSettingsSlotArgs].
 */
@PulumiTagMarker
public class WebAppSitePushSettingsSlotArgsBuilder internal constructor() {
    private var dynamicTagsJson: Output<String>? = null

    private var isPushEnabled: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    private var tagWhitelistJson: Output<String>? = null

    private var tagsRequiringAuth: Output<String>? = null

    /**
     * @param value Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
     */
    @JvmName("krodjxetusbrvdcc")
    public suspend fun dynamicTagsJson(`value`: Output<String>) {
        this.dynamicTagsJson = value
    }

    /**
     * @param value Gets or sets a flag indicating whether the Push endpoint is enabled.
     */
    @JvmName("ekfdlafkhbirwpyh")
    public suspend fun isPushEnabled(`value`: Output<Boolean>) {
        this.isPushEnabled = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("okyeqsyspklospea")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of web app.
     */
    @JvmName("qfgxfkolarggymqt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("clewfxossdoggjok")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of web app slot. If not specified then will default to production slot.
     */
    @JvmName("spsvhigagjxccuua")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
     */
    @JvmName("xojmnyvaxgbexjre")
    public suspend fun tagWhitelistJson(`value`: Output<String>) {
        this.tagWhitelistJson = value
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
     * Tags can consist of alphanumeric characters and the following:
     * '_', '@', '#', '.', ':', '-'.
     * Validation should be performed at the PushRequestHandler.
     */
    @JvmName("hhwdmiwmnqnxatkk")
    public suspend fun tagsRequiringAuth(`value`: Output<String>) {
        this.tagsRequiringAuth = value
    }

    /**
     * @param value Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
     */
    @JvmName("ujghiwlssqlqrgbh")
    public suspend fun dynamicTagsJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicTagsJson = mapped
    }

    /**
     * @param value Gets or sets a flag indicating whether the Push endpoint is enabled.
     */
    @JvmName("fsccvqtnrmkdexfr")
    public suspend fun isPushEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPushEnabled = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("hngvsbjpyqnrwkjp")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of web app.
     */
    @JvmName("uyflbccnadysownq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("rammmciyhvjdggbh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of web app slot. If not specified then will default to production slot.
     */
    @JvmName("gyfatvkgubtoomko")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
     */
    @JvmName("kkpwyjivwefnryel")
    public suspend fun tagWhitelistJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagWhitelistJson = mapped
    }

    /**
     * @param value Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
     * Tags can consist of alphanumeric characters and the following:
     * '_', '@', '#', '.', ':', '-'.
     * Validation should be performed at the PushRequestHandler.
     */
    @JvmName("krxkrleyypcppmbh")
    public suspend fun tagsRequiringAuth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagsRequiringAuth = mapped
    }

    internal fun build(): WebAppSitePushSettingsSlotArgs = WebAppSitePushSettingsSlotArgs(
        dynamicTagsJson = dynamicTagsJson,
        isPushEnabled = isPushEnabled,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        slot = slot,
        tagWhitelistJson = tagWhitelistJson,
        tagsRequiringAuth = tagsRequiringAuth,
    )
}
