@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSwiftVirtualNetworkConnectionSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork
 * ```
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will add or update connections for the production slot.
 * @property subnetResourceId The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
 * @property swiftSupported A flag that specifies if the scale unit this Web App is on supports Swift integration.
 */
public data class WebAppSwiftVirtualNetworkConnectionSlotArgs(
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
    public val subnetResourceId: Output<String>? = null,
    public val swiftSupported: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionSlotArgs =
        com.pulumi.azurenative.web.WebAppSwiftVirtualNetworkConnectionSlotArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 }))
            .subnetResourceId(subnetResourceId?.applyValue({ args0 -> args0 }))
            .swiftSupported(swiftSupported?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSwiftVirtualNetworkConnectionSlotArgs].
 */
@PulumiTagMarker
public class WebAppSwiftVirtualNetworkConnectionSlotArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    private var subnetResourceId: Output<String>? = null

    private var swiftSupported: Output<Boolean>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("wnvvaixvjyecmkrt")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("jakhlnuvsklpaerb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("kkgoieeteviylpkv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will add or update connections for the production slot.
     */
    @JvmName("oinktdjegwknogyj")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
     */
    @JvmName("ukdkvxogycaqbdvj")
    public suspend fun subnetResourceId(`value`: Output<String>) {
        this.subnetResourceId = value
    }

    /**
     * @param value A flag that specifies if the scale unit this Web App is on supports Swift integration.
     */
    @JvmName("obfamvyqbykteiit")
    public suspend fun swiftSupported(`value`: Output<Boolean>) {
        this.swiftSupported = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("bhcrmmisibfajbtv")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("ixfgmpoykkaqatos")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("njkdihuvoswhqdhl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will add or update connections for the production slot.
     */
    @JvmName("fwlftafbejvirykc")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    /**
     * @param value The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
     */
    @JvmName("rebnxsdynlqmomcp")
    public suspend fun subnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetResourceId = mapped
    }

    /**
     * @param value A flag that specifies if the scale unit this Web App is on supports Swift integration.
     */
    @JvmName("qgyhouaimhnqfbcl")
    public suspend fun swiftSupported(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swiftSupported = mapped
    }

    internal fun build(): WebAppSwiftVirtualNetworkConnectionSlotArgs =
        WebAppSwiftVirtualNetworkConnectionSlotArgs(
            kind = kind,
            name = name,
            resourceGroupName = resourceGroupName,
            slot = slot,
            subnetResourceId = subnetResourceId,
            swiftSupported = swiftSupported,
        )
}
