@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The convention used when determining the session cookie's expiration.
 */
public enum class CookieExpirationConvention(
    public val javaValue: com.pulumi.azurenative.web.enums.CookieExpirationConvention,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.CookieExpirationConvention> {
    FixedTime(com.pulumi.azurenative.web.enums.CookieExpirationConvention.FixedTime),
    IdentityProviderDerived(com.pulumi.azurenative.web.enums.CookieExpirationConvention.IdentityProviderDerived),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.CookieExpirationConvention = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.CookieExpirationConvention):
            CookieExpirationConvention =
            CookieExpirationConvention.values().first { it.javaValue == javaType }
    }
}
