@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * State indicating the status of the enterprise grade CDN serving traffic to the static web app.
 */
public enum class EnterpriseGradeCdnStatus(
    public val javaValue: com.pulumi.azurenative.web.enums.EnterpriseGradeCdnStatus,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.EnterpriseGradeCdnStatus> {
    Enabled(com.pulumi.azurenative.web.enums.EnterpriseGradeCdnStatus.Enabled),
    Enabling(com.pulumi.azurenative.web.enums.EnterpriseGradeCdnStatus.Enabling),
    Disabled(com.pulumi.azurenative.web.enums.EnterpriseGradeCdnStatus.Disabled),
    Disabling(com.pulumi.azurenative.web.enums.EnterpriseGradeCdnStatus.Disabling),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.EnterpriseGradeCdnStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.EnterpriseGradeCdnStatus):
            EnterpriseGradeCdnStatus =
            EnterpriseGradeCdnStatus.values().first { it.javaValue == javaType }
    }
}
