@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines what this IP filter will be used for. This is to support IP filtering on proxies.
 */
public enum class IpFilterTag(
    public val javaValue: com.pulumi.azurenative.web.enums.IpFilterTag,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.IpFilterTag> {
    Default(com.pulumi.azurenative.web.enums.IpFilterTag.Default),
    XffProxy(com.pulumi.azurenative.web.enums.IpFilterTag.XffProxy),
    ServiceTag(com.pulumi.azurenative.web.enums.IpFilterTag.ServiceTag),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.IpFilterTag = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.IpFilterTag): IpFilterTag =
            IpFilterTag.values().first { it.javaValue == javaType }
    }
}
