@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApiConnectionTestLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API connection properties
 * @property method HTTP Method
 * @property requestUri Test link request URI
 */
public data class ApiConnectionTestLinkArgs(
    public val method: Output<String>? = null,
    public val requestUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApiConnectionTestLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApiConnectionTestLinkArgs =
        com.pulumi.azurenative.web.inputs.ApiConnectionTestLinkArgs.builder()
            .method(method?.applyValue({ args0 -> args0 }))
            .requestUri(requestUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiConnectionTestLinkArgs].
 */
@PulumiTagMarker
public class ApiConnectionTestLinkArgsBuilder internal constructor() {
    private var method: Output<String>? = null

    private var requestUri: Output<String>? = null

    /**
     * @param value HTTP Method
     */
    @JvmName("kfqcisuqmowohcle")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Test link request URI
     */
    @JvmName("geofxntmhvsuscpf")
    public suspend fun requestUri(`value`: Output<String>) {
        this.requestUri = value
    }

    /**
     * @param value HTTP Method
     */
    @JvmName("xccqxxlcpyaxhmym")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Test link request URI
     */
    @JvmName("owgwmrnwyqmimnqt")
    public suspend fun requestUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestUri = mapped
    }

    internal fun build(): ApiConnectionTestLinkArgs = ApiConnectionTestLinkArgs(
        method = method,
        requestUri = requestUri,
    )
}
