@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApiOAuthSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * OAuth settings for the connection provider
 * @property clientId Resource provider client id
 * @property clientSecret Client Secret needed for OAuth
 * @property customParameters OAuth parameters key is the name of parameter
 * @property identityProvider Identity provider
 * @property properties Read only properties for this oauth setting.
 * @property redirectUrl Url
 * @property scopes OAuth scopes
 */
public data class ApiOAuthSettingsArgs(
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val customParameters: Output<Map<String, ApiOAuthSettingsParameterArgs>>? = null,
    public val identityProvider: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val redirectUrl: Output<String>? = null,
    public val scopes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApiOAuthSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApiOAuthSettingsArgs =
        com.pulumi.azurenative.web.inputs.ApiOAuthSettingsArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .customParameters(
                customParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .identityProvider(identityProvider?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .redirectUrl(redirectUrl?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApiOAuthSettingsArgs].
 */
@PulumiTagMarker
public class ApiOAuthSettingsArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var customParameters: Output<Map<String, ApiOAuthSettingsParameterArgs>>? = null

    private var identityProvider: Output<String>? = null

    private var properties: Output<Any>? = null

    private var redirectUrl: Output<String>? = null

    private var scopes: Output<List<String>>? = null

    /**
     * @param value Resource provider client id
     */
    @JvmName("npdbbswynqxnbtke")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Client Secret needed for OAuth
     */
    @JvmName("vceigfwvgpfnhkkf")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value OAuth parameters key is the name of parameter
     */
    @JvmName("vrwpnwhqiosbndul")
    public suspend fun customParameters(`value`: Output<Map<String, ApiOAuthSettingsParameterArgs>>) {
        this.customParameters = value
    }

    /**
     * @param value Identity provider
     */
    @JvmName("xbvlnqnigglykova")
    public suspend fun identityProvider(`value`: Output<String>) {
        this.identityProvider = value
    }

    /**
     * @param value Read only properties for this oauth setting.
     */
    @JvmName("nlrbvekgkkxkmsim")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value Url
     */
    @JvmName("cbuhskagatkxbvyt")
    public suspend fun redirectUrl(`value`: Output<String>) {
        this.redirectUrl = value
    }

    /**
     * @param value OAuth scopes
     */
    @JvmName("otjxksojnbcsyaol")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("icfsdvdhkmkrbavn")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values OAuth scopes
     */
    @JvmName("tgueuflkgtcujbqr")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value Resource provider client id
     */
    @JvmName("hyxusetucewugqhj")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Client Secret needed for OAuth
     */
    @JvmName("diikqoakjrqtnfir")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value OAuth parameters key is the name of parameter
     */
    @JvmName("evxcsykgovvaebdk")
    public suspend fun customParameters(`value`: Map<String, ApiOAuthSettingsParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customParameters = mapped
    }

    /**
     * @param argument OAuth parameters key is the name of parameter
     */
    @JvmName("treryvwueaxtxokl")
    public suspend fun customParameters(
        vararg
        argument: Pair<String, suspend ApiOAuthSettingsParameterArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ApiOAuthSettingsParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.customParameters = mapped
    }

    /**
     * @param values OAuth parameters key is the name of parameter
     */
    @JvmName("ogdkuqccqgiwggbl")
    public fun customParameters(vararg values: Pair<String, ApiOAuthSettingsParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customParameters = mapped
    }

    /**
     * @param value Identity provider
     */
    @JvmName("aacfdmgtdcqtdjww")
    public suspend fun identityProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProvider = mapped
    }

    /**
     * @param value Read only properties for this oauth setting.
     */
    @JvmName("nxrcwavlyaksspit")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Url
     */
    @JvmName("ouehtfeplmyfvbpd")
    public suspend fun redirectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectUrl = mapped
    }

    /**
     * @param value OAuth scopes
     */
    @JvmName("merpdsfqspyrgxfv")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values OAuth scopes
     */
    @JvmName("pxmnnhhdgrxlgcqe")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    internal fun build(): ApiOAuthSettingsArgs = ApiOAuthSettingsArgs(
        clientId = clientId,
        clientSecret = clientSecret,
        customParameters = customParameters,
        identityProvider = identityProvider,
        properties = properties,
        redirectUrl = redirectUrl,
        scopes = scopes,
    )
}
